// chrome/browser/ui/webui/ash/borealis_installer/borealis_installer.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { InstallResultSpec as borealis_mojom_InstallResultSpec } from './borealis_types.mojom-webui.js';
export class PageHandlerFactoryPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.borealis_installer.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "ash.borealis_installer.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.borealis_installer.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    install() {
        this.proxy.sendMessage(0, PageHandler_Install_ParamsSpec.$, null, [], false);
    }
    shutDown() {
        this.proxy.sendMessage(1, PageHandler_ShutDown_ParamsSpec.$, null, [], false);
    }
    launch() {
        this.proxy.sendMessage(2, PageHandler_Launch_ParamsSpec.$, null, [], false);
    }
    cancelInstall() {
        this.proxy.sendMessage(3, PageHandler_CancelInstall_ParamsSpec.$, null, [], false);
    }
    onPageClosed() {
        this.proxy.sendMessage(4, PageHandler_OnPageClosed_ParamsSpec.$, null, [], false);
    }
    openStoragePage() {
        this.proxy.sendMessage(5, PageHandler_OpenStoragePage_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_Install_ParamsSpec.$, null, impl.install.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_ShutDown_ParamsSpec.$, null, impl.shutDown.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_Launch_ParamsSpec.$, null, impl.launch.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_CancelInstall_ParamsSpec.$, null, impl.cancelInstall.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_OnPageClosed_ParamsSpec.$, null, impl.onPageClosed.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_OpenStoragePage_ParamsSpec.$, null, impl.openStoragePage.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "ash.borealis_installer.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.install =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_Install_ParamsSpec.$, null, this.install.createReceiverHandler(false /* expectsResponse */), false);
        this.shutDown =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_ShutDown_ParamsSpec.$, null, this.shutDown.createReceiverHandler(false /* expectsResponse */), false);
        this.launch =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_Launch_ParamsSpec.$, null, this.launch.createReceiverHandler(false /* expectsResponse */), false);
        this.cancelInstall =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_CancelInstall_ParamsSpec.$, null, this.cancelInstall.createReceiverHandler(false /* expectsResponse */), false);
        this.onPageClosed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_OnPageClosed_ParamsSpec.$, null, this.onPageClosed.createReceiverHandler(false /* expectsResponse */), false);
        this.openStoragePage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_OpenStoragePage_ParamsSpec.$, null, this.openStoragePage.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.borealis_installer.mojom.Page', scope);
    }
}
export class PageRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onProgressUpdate(progressFraction, label) {
        this.proxy.sendMessage(0, Page_OnProgressUpdate_ParamsSpec.$, null, [
            progressFraction,
            label
        ], false);
    }
    onInstallFinished(error) {
        this.proxy.sendMessage(1, Page_OnInstallFinished_ParamsSpec.$, null, [
            error
        ], false);
    }
    requestClose() {
        this.proxy.sendMessage(2, Page_RequestClose_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_OnProgressUpdate_ParamsSpec.$, null, impl.onProgressUpdate.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_OnInstallFinished_ParamsSpec.$, null, impl.onInstallFinished.bind(impl), false);
        this.helper_internal_.registerHandler(2, Page_RequestClose_ParamsSpec.$, null, impl.requestClose.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "ash.borealis_installer.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onProgressUpdate =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_OnProgressUpdate_ParamsSpec.$, null, this.onProgressUpdate.createReceiverHandler(false /* expectsResponse */), false);
        this.onInstallFinished =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_OnInstallFinished_ParamsSpec.$, null, this.onInstallFinished.createReceiverHandler(false /* expectsResponse */), false);
        this.requestClose =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Page_RequestClose_ParamsSpec.$, null, this.requestClose.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_Install_ParamsSpec = { $: {} };
export const PageHandler_ShutDown_ParamsSpec = { $: {} };
export const PageHandler_Launch_ParamsSpec = { $: {} };
export const PageHandler_CancelInstall_ParamsSpec = { $: {} };
export const PageHandler_OnPageClosed_ParamsSpec = { $: {} };
export const PageHandler_OpenStoragePage_ParamsSpec = { $: {} };
export const Page_OnProgressUpdate_ParamsSpec = { $: {} };
export const Page_OnInstallFinished_ParamsSpec = { $: {} };
export const Page_RequestClose_ParamsSpec = { $: {} };
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_Install_ParamsSpec.$, 'PageHandler_Install_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_ShutDown_ParamsSpec.$, 'PageHandler_ShutDown_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_Launch_ParamsSpec.$, 'PageHandler_Launch_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_CancelInstall_ParamsSpec.$, 'PageHandler_CancelInstall_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OnPageClosed_ParamsSpec.$, 'PageHandler_OnPageClosed_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OpenStoragePage_ParamsSpec.$, 'PageHandler_OpenStoragePage_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_OnProgressUpdate_ParamsSpec.$, 'Page_OnProgressUpdate_Params', [
    mojo.internal.StructField('progressFraction', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('label', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Page_OnInstallFinished_ParamsSpec.$, 'Page_OnInstallFinished_Params', [
    mojo.internal.StructField('error', 0, 0, borealis_mojom_InstallResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_RequestClose_ParamsSpec.$, 'Page_RequestClose_Params', [], [[0, 8],]);
