// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./setup_cancel_dialog.js";import{assert}from"chrome://resources/js/assert.js";import{CANCEL_SETUP_EVENT,NEXT_PAGE_EVENT}from"./base_setup_page.js";import{MetricsRecordedSetupPage,UserAction}from"./cloud_upload.mojom-webui.js";import{CloudUploadBrowserProxy}from"./cloud_upload_browser_proxy.js";import{OfficePwaInstallPageElement}from"./office_pwa_install_page.js";import{OfficeSetupCompletePageElement}from"./office_setup_complete_page.js";import{SignInPageElement}from"./sign_in_page.js";import{WelcomePageElement}from"./welcome_page.js";export class CloudUploadElement extends HTMLElement{constructor(){super();this.proxy=CloudUploadBrowserProxy.getInstance();this.pages=[];this.currentPageIdx=0;this.setOfficeAsDefaultHandler=true;this.fileNames=[];const shadow=this.attachShadow({mode:"open"});this.cancelDialog=document.createElement("setup-cancel-dialog");shadow.appendChild(this.cancelDialog);this.boundKeyDownListener_=this.onKeyDown.bind(this);this.initPromise=this.init()}connectedCallback(){document.addEventListener("keydown",this.boundKeyDownListener_)}disconnectedCallback(){document.removeEventListener("keydown",this.boundKeyDownListener_)}async init(){const[,{installed:isOfficeWebAppInstalled},{mounted:isOdfsMounted}]=await Promise.all([this.processDialogArgs(),this.proxy.handler.isOfficeWebAppInstalled(),this.proxy.handler.isODFSMounted()]);if(this.fileNames.length!==0||this.setOfficeAsDefaultHandler){const welcomePage=new WelcomePageElement;welcomePage.setInstalled(isOfficeWebAppInstalled,isOdfsMounted);this.pages.push(welcomePage)}if(!isOfficeWebAppInstalled){this.pages.push(new OfficePwaInstallPageElement)}if(!isOdfsMounted){this.pages.push(new SignInPageElement)}const officeSetupCompletePage=new OfficeSetupCompletePageElement;officeSetupCompletePage.setDefaultHandlerOnPageShown(this.setOfficeAsDefaultHandler);this.pages.push(officeSetupCompletePage);for(const page of this.pages){page.addEventListener(NEXT_PAGE_EVENT,(()=>this.goNextPage()));page.addEventListener(CANCEL_SETUP_EVENT,(()=>this.cancelSetup()))}this.switchPage(0)}$(query){return this.shadowRoot.querySelector(query)}get currentPage(){return this.pages[this.currentPageIdx]}switchPage(page){this.currentPage?.remove();this.currentPageIdx=page;this.shadowRoot.appendChild(this.currentPage)}async processDialogArgs(){try{const dialogArgs=await this.proxy.handler.getDialogArgs();assert(dialogArgs.args);assert(dialogArgs.args.dialogSpecificArgs.oneDriveSetupDialogArgs);this.setOfficeAsDefaultHandler=dialogArgs.args.dialogSpecificArgs.oneDriveSetupDialogArgs.setOfficeAsDefaultHandler;this.fileNames=dialogArgs.args.fileNames}catch(e){console.error(`Unable to get dialog arguments . Error: ${e}.`)}}onKeyDown(event){if(event.key==="Escape"&&!this.cancelDialog.open){this.cancelSetup();event.stopImmediatePropagation();event.preventDefault()}}currentPageToMetricsPage(){if(this.currentPage instanceof WelcomePageElement){return MetricsRecordedSetupPage.kOneDriveSetupWelcome}else if(this.currentPage instanceof OfficePwaInstallPageElement){return MetricsRecordedSetupPage.kOneDriveSetupPWAInstall}else if(this.currentPage instanceof SignInPageElement){return MetricsRecordedSetupPage.kOneDriveSetupODFSMount}else if(this.currentPage instanceof OfficeSetupCompletePageElement){return MetricsRecordedSetupPage.kOneDriveSetupComplete}return null}cancelSetup(){if(this.currentPage instanceof OfficeSetupCompletePageElement){this.proxy.handler.respondWithUserActionAndClose(UserAction.kCancel);return}this.cancelDialog.show((()=>{const metricsPage=this.currentPageToMetricsPage();if(metricsPage!=null){this.proxy.handler.recordCancel(metricsPage)}this.proxy.handler.respondWithUserActionAndClose(UserAction.kCancel)}))}goNextPage(){if(this.currentPageIdx<this.pages.length-1){this.switchPage(this.currentPageIdx+1)}}}customElements.define("cloud-upload",CloudUploadElement);