// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"/strings.m.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{UserAction}from"./cloud_upload.mojom-webui.js";import{CloudUploadBrowserProxy}from"./cloud_upload_browser_proxy.js";import{getTemplate}from"./connect_onedrive.html.js";export class ConnectOneDriveElement extends HTMLElement{constructor(){super();this.proxy=CloudUploadBrowserProxy.getInstance();const shadowRoot=this.attachShadow({mode:"open"});shadowRoot.innerHTML=getTemplate();const connectButton=this.$(".action-button");const closeButton=this.$(".cancel-button");connectButton.addEventListener("click",(()=>this.onConnectButtonClick()));closeButton.addEventListener("click",(()=>this.onCloseButtonClick()));this.boundKeyDownListener_=this.onKeyDown.bind(this)}connectedCallback(){document.addEventListener("keydown",this.boundKeyDownListener_)}disconnectedCallback(){document.removeEventListener("keydown",this.boundKeyDownListener_)}$(query){return this.shadowRoot.querySelector(query)}async onConnectButtonClick(){const{success:signInSuccess}=await this.proxy.handler.signInToOneDrive();if(signInSuccess){this.shadowRoot.querySelector("#install").setAttribute("visibility","hidden");this.shadowRoot.querySelector("#success").setAttribute("visibility","visible");this.$("#title").innerText=loadTimeData.getString("oneDriveConnectedTitle");this.$("#body-text").innerText=loadTimeData.getString("oneDriveConnectedBodyText");this.$(".action-button").remove()}else{this.$("#error-message").toggleAttribute("hidden",false)}}onCloseButtonClick(){this.proxy.handler.respondWithUserActionAndClose(UserAction.kCancel)}onKeyDown(e){if(e.key==="Escape"){e.stopImmediatePropagation();e.preventDefault();this.onCloseButtonClick();return}}}customElements.define("connect-onedrive",ConnectOneDriveElement);