// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/cr_icons.css.js";import{CrButtonElement}from"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import{assertInstanceof}from"chrome://resources/js/assert.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{BaseSetupPageElement,CANCEL_SETUP_EVENT,NEXT_PAGE_EVENT}from"./base_setup_page.js";import{CloudUploadBrowserProxy}from"./cloud_upload_browser_proxy.js";import{getTemplate}from"./office_pwa_install_page.html.js";export class OfficePwaInstallPageElement extends BaseSetupPageElement{connectedCallback(){super.connectedCallback();this.innerHTML=getTemplate();const actionButton=this.querySelector(".action-button");actionButton.addEventListener("click",this.onActionButtonClick.bind(this));const cancelButton=this.querySelector(".cancel-button");cancelButton.addEventListener("click",this.onCancelButtonClick.bind(this))}async onActionButtonClick(event){const proxy=CloudUploadBrowserProxy.getInstance();assertInstanceof(event.target,CrButtonElement);const actionButton=event.target;actionButton.innerText=loadTimeData.getString("installing");actionButton.classList.replace("install","installing");actionButton.disabled=true;const testTime=30;const installingTime=3e3;const[{installed:install_result}]=await Promise.all([proxy.handler.installOfficeWebApp(),new Promise((resolve=>setTimeout(resolve,proxy.isTest()?testTime:installingTime)))]);if(install_result){actionButton.innerText=loadTimeData.getString("installed");actionButton.classList.replace("installing","installed");const installedTime=2e3;await new Promise((resolve=>setTimeout(resolve,proxy.isTest()?testTime:installedTime)));this.dispatchEvent(new CustomEvent(NEXT_PAGE_EVENT,{bubbles:true,composed:true}))}else{actionButton.innerText=loadTimeData.getString("install");actionButton.classList.replace("installing","install");actionButton.disabled=false}}onCancelButtonClick(){this.dispatchEvent(new CustomEvent(CANCEL_SETUP_EVENT,{bubbles:true,composed:true}))}}customElements.define("office-pwa-install-page",OfficePwaInstallPageElement);