// chrome/browser/ui/webui/ash/cloud_upload/cloud_upload.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export const UserActionSpec = { $: mojo.internal.Enum() };
export var UserAction;
(function (UserAction) {
    UserAction[UserAction["MIN_VALUE"] = 0] = "MIN_VALUE";
    UserAction[UserAction["MAX_VALUE"] = 7] = "MAX_VALUE";
    UserAction[UserAction["kCancel"] = 0] = "kCancel";
    UserAction[UserAction["kCancelGoogleDrive"] = 1] = "kCancelGoogleDrive";
    UserAction[UserAction["kCancelOneDrive"] = 2] = "kCancelOneDrive";
    UserAction[UserAction["kSetUpOneDrive"] = 3] = "kSetUpOneDrive";
    UserAction[UserAction["kUploadToGoogleDrive"] = 4] = "kUploadToGoogleDrive";
    UserAction[UserAction["kUploadToOneDrive"] = 5] = "kUploadToOneDrive";
    UserAction[UserAction["kConfirmOrUploadToGoogleDrive"] = 6] = "kConfirmOrUploadToGoogleDrive";
    UserAction[UserAction["kConfirmOrUploadToOneDrive"] = 7] = "kConfirmOrUploadToOneDrive";
})(UserAction || (UserAction = {}));
export const MetricsRecordedSetupPageSpec = { $: mojo.internal.Enum() };
export var MetricsRecordedSetupPage;
(function (MetricsRecordedSetupPage) {
    MetricsRecordedSetupPage[MetricsRecordedSetupPage["MIN_VALUE"] = 0] = "MIN_VALUE";
    MetricsRecordedSetupPage[MetricsRecordedSetupPage["MAX_VALUE"] = 6] = "MAX_VALUE";
    MetricsRecordedSetupPage[MetricsRecordedSetupPage["kFileHandlerPage"] = 0] = "kFileHandlerPage";
    MetricsRecordedSetupPage[MetricsRecordedSetupPage["kMoveConfirmationOneDrive"] = 1] = "kMoveConfirmationOneDrive";
    MetricsRecordedSetupPage[MetricsRecordedSetupPage["kMoveConfirmationGoogleDrive"] = 2] = "kMoveConfirmationGoogleDrive";
    MetricsRecordedSetupPage[MetricsRecordedSetupPage["kOneDriveSetupWelcome"] = 3] = "kOneDriveSetupWelcome";
    MetricsRecordedSetupPage[MetricsRecordedSetupPage["kOneDriveSetupPWAInstall"] = 4] = "kOneDriveSetupPWAInstall";
    MetricsRecordedSetupPage[MetricsRecordedSetupPage["kOneDriveSetupODFSMount"] = 5] = "kOneDriveSetupODFSMount";
    MetricsRecordedSetupPage[MetricsRecordedSetupPage["kOneDriveSetupComplete"] = 6] = "kOneDriveSetupComplete";
})(MetricsRecordedSetupPage || (MetricsRecordedSetupPage = {}));
export const OperationTypeSpec = { $: mojo.internal.Enum() };
export var OperationType;
(function (OperationType) {
    OperationType[OperationType["MIN_VALUE"] = 0] = "MIN_VALUE";
    OperationType[OperationType["MAX_VALUE"] = 1] = "MAX_VALUE";
    OperationType[OperationType["kMove"] = 0] = "kMove";
    OperationType[OperationType["kCopy"] = 1] = "kCopy";
})(OperationType || (OperationType = {}));
export class PageHandlerFactoryPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.cloud_upload.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "ash.cloud_upload.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.cloud_upload.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getDialogArgs() {
        return this.proxy.sendMessage(0, PageHandler_GetDialogArgs_ParamsSpec.$, PageHandler_GetDialogArgs_ResponseParamsSpec.$, [], false);
    }
    isOfficeWebAppInstalled() {
        return this.proxy.sendMessage(1, PageHandler_IsOfficeWebAppInstalled_ParamsSpec.$, PageHandler_IsOfficeWebAppInstalled_ResponseParamsSpec.$, [], false);
    }
    installOfficeWebApp() {
        return this.proxy.sendMessage(2, PageHandler_InstallOfficeWebApp_ParamsSpec.$, PageHandler_InstallOfficeWebApp_ResponseParamsSpec.$, [], false);
    }
    isODFSMounted() {
        return this.proxy.sendMessage(3, PageHandler_IsODFSMounted_ParamsSpec.$, PageHandler_IsODFSMounted_ResponseParamsSpec.$, [], false);
    }
    signInToOneDrive() {
        return this.proxy.sendMessage(4, PageHandler_SignInToOneDrive_ParamsSpec.$, PageHandler_SignInToOneDrive_ResponseParamsSpec.$, [], false);
    }
    respondWithUserActionAndClose(response) {
        this.proxy.sendMessage(5, PageHandler_RespondWithUserActionAndClose_ParamsSpec.$, null, [
            response
        ], false);
    }
    respondWithLocalTaskAndClose(taskPosition) {
        this.proxy.sendMessage(6, PageHandler_RespondWithLocalTaskAndClose_ParamsSpec.$, null, [
            taskPosition
        ], false);
    }
    setOfficeAsDefaultHandler() {
        this.proxy.sendMessage(7, PageHandler_SetOfficeAsDefaultHandler_ParamsSpec.$, null, [], false);
    }
    getAlwaysMoveOfficeFilesToDrive() {
        return this.proxy.sendMessage(8, PageHandler_GetAlwaysMoveOfficeFilesToDrive_ParamsSpec.$, PageHandler_GetAlwaysMoveOfficeFilesToDrive_ResponseParamsSpec.$, [], false);
    }
    setAlwaysMoveOfficeFilesToDrive(alwaysMove) {
        this.proxy.sendMessage(9, PageHandler_SetAlwaysMoveOfficeFilesToDrive_ParamsSpec.$, null, [
            alwaysMove
        ], false);
    }
    getAlwaysMoveOfficeFilesToOneDrive() {
        return this.proxy.sendMessage(10, PageHandler_GetAlwaysMoveOfficeFilesToOneDrive_ParamsSpec.$, PageHandler_GetAlwaysMoveOfficeFilesToOneDrive_ResponseParamsSpec.$, [], false);
    }
    setAlwaysMoveOfficeFilesToOneDrive(alwaysMove) {
        this.proxy.sendMessage(11, PageHandler_SetAlwaysMoveOfficeFilesToOneDrive_ParamsSpec.$, null, [
            alwaysMove
        ], false);
    }
    getOfficeMoveConfirmationShownForDrive() {
        return this.proxy.sendMessage(12, PageHandler_GetOfficeMoveConfirmationShownForDrive_ParamsSpec.$, PageHandler_GetOfficeMoveConfirmationShownForDrive_ResponseParamsSpec.$, [], false);
    }
    getOfficeMoveConfirmationShownForOneDrive() {
        return this.proxy.sendMessage(13, PageHandler_GetOfficeMoveConfirmationShownForOneDrive_ParamsSpec.$, PageHandler_GetOfficeMoveConfirmationShownForOneDrive_ResponseParamsSpec.$, [], false);
    }
    recordCancel(page) {
        this.proxy.sendMessage(14, PageHandler_RecordCancel_ParamsSpec.$, null, [
            page
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_GetDialogArgs_ParamsSpec.$, PageHandler_GetDialogArgs_ResponseParamsSpec.$, impl.getDialogArgs.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_IsOfficeWebAppInstalled_ParamsSpec.$, PageHandler_IsOfficeWebAppInstalled_ResponseParamsSpec.$, impl.isOfficeWebAppInstalled.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_InstallOfficeWebApp_ParamsSpec.$, PageHandler_InstallOfficeWebApp_ResponseParamsSpec.$, impl.installOfficeWebApp.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_IsODFSMounted_ParamsSpec.$, PageHandler_IsODFSMounted_ResponseParamsSpec.$, impl.isODFSMounted.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_SignInToOneDrive_ParamsSpec.$, PageHandler_SignInToOneDrive_ResponseParamsSpec.$, impl.signInToOneDrive.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_RespondWithUserActionAndClose_ParamsSpec.$, null, impl.respondWithUserActionAndClose.bind(impl), false);
        this.helper_internal_.registerHandler(6, PageHandler_RespondWithLocalTaskAndClose_ParamsSpec.$, null, impl.respondWithLocalTaskAndClose.bind(impl), false);
        this.helper_internal_.registerHandler(7, PageHandler_SetOfficeAsDefaultHandler_ParamsSpec.$, null, impl.setOfficeAsDefaultHandler.bind(impl), false);
        this.helper_internal_.registerHandler(8, PageHandler_GetAlwaysMoveOfficeFilesToDrive_ParamsSpec.$, PageHandler_GetAlwaysMoveOfficeFilesToDrive_ResponseParamsSpec.$, impl.getAlwaysMoveOfficeFilesToDrive.bind(impl), false);
        this.helper_internal_.registerHandler(9, PageHandler_SetAlwaysMoveOfficeFilesToDrive_ParamsSpec.$, null, impl.setAlwaysMoveOfficeFilesToDrive.bind(impl), false);
        this.helper_internal_.registerHandler(10, PageHandler_GetAlwaysMoveOfficeFilesToOneDrive_ParamsSpec.$, PageHandler_GetAlwaysMoveOfficeFilesToOneDrive_ResponseParamsSpec.$, impl.getAlwaysMoveOfficeFilesToOneDrive.bind(impl), false);
        this.helper_internal_.registerHandler(11, PageHandler_SetAlwaysMoveOfficeFilesToOneDrive_ParamsSpec.$, null, impl.setAlwaysMoveOfficeFilesToOneDrive.bind(impl), false);
        this.helper_internal_.registerHandler(12, PageHandler_GetOfficeMoveConfirmationShownForDrive_ParamsSpec.$, PageHandler_GetOfficeMoveConfirmationShownForDrive_ResponseParamsSpec.$, impl.getOfficeMoveConfirmationShownForDrive.bind(impl), false);
        this.helper_internal_.registerHandler(13, PageHandler_GetOfficeMoveConfirmationShownForOneDrive_ParamsSpec.$, PageHandler_GetOfficeMoveConfirmationShownForOneDrive_ResponseParamsSpec.$, impl.getOfficeMoveConfirmationShownForOneDrive.bind(impl), false);
        this.helper_internal_.registerHandler(14, PageHandler_RecordCancel_ParamsSpec.$, null, impl.recordCancel.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "ash.cloud_upload.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getDialogArgs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_GetDialogArgs_ParamsSpec.$, PageHandler_GetDialogArgs_ResponseParamsSpec.$, this.getDialogArgs.createReceiverHandler(true /* expectsResponse */), false);
        this.isOfficeWebAppInstalled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_IsOfficeWebAppInstalled_ParamsSpec.$, PageHandler_IsOfficeWebAppInstalled_ResponseParamsSpec.$, this.isOfficeWebAppInstalled.createReceiverHandler(true /* expectsResponse */), false);
        this.installOfficeWebApp =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_InstallOfficeWebApp_ParamsSpec.$, PageHandler_InstallOfficeWebApp_ResponseParamsSpec.$, this.installOfficeWebApp.createReceiverHandler(true /* expectsResponse */), false);
        this.isODFSMounted =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_IsODFSMounted_ParamsSpec.$, PageHandler_IsODFSMounted_ResponseParamsSpec.$, this.isODFSMounted.createReceiverHandler(true /* expectsResponse */), false);
        this.signInToOneDrive =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_SignInToOneDrive_ParamsSpec.$, PageHandler_SignInToOneDrive_ResponseParamsSpec.$, this.signInToOneDrive.createReceiverHandler(true /* expectsResponse */), false);
        this.respondWithUserActionAndClose =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_RespondWithUserActionAndClose_ParamsSpec.$, null, this.respondWithUserActionAndClose.createReceiverHandler(false /* expectsResponse */), false);
        this.respondWithLocalTaskAndClose =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PageHandler_RespondWithLocalTaskAndClose_ParamsSpec.$, null, this.respondWithLocalTaskAndClose.createReceiverHandler(false /* expectsResponse */), false);
        this.setOfficeAsDefaultHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, PageHandler_SetOfficeAsDefaultHandler_ParamsSpec.$, null, this.setOfficeAsDefaultHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.getAlwaysMoveOfficeFilesToDrive =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, PageHandler_GetAlwaysMoveOfficeFilesToDrive_ParamsSpec.$, PageHandler_GetAlwaysMoveOfficeFilesToDrive_ResponseParamsSpec.$, this.getAlwaysMoveOfficeFilesToDrive.createReceiverHandler(true /* expectsResponse */), false);
        this.setAlwaysMoveOfficeFilesToDrive =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, PageHandler_SetAlwaysMoveOfficeFilesToDrive_ParamsSpec.$, null, this.setAlwaysMoveOfficeFilesToDrive.createReceiverHandler(false /* expectsResponse */), false);
        this.getAlwaysMoveOfficeFilesToOneDrive =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, PageHandler_GetAlwaysMoveOfficeFilesToOneDrive_ParamsSpec.$, PageHandler_GetAlwaysMoveOfficeFilesToOneDrive_ResponseParamsSpec.$, this.getAlwaysMoveOfficeFilesToOneDrive.createReceiverHandler(true /* expectsResponse */), false);
        this.setAlwaysMoveOfficeFilesToOneDrive =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, PageHandler_SetAlwaysMoveOfficeFilesToOneDrive_ParamsSpec.$, null, this.setAlwaysMoveOfficeFilesToOneDrive.createReceiverHandler(false /* expectsResponse */), false);
        this.getOfficeMoveConfirmationShownForDrive =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, PageHandler_GetOfficeMoveConfirmationShownForDrive_ParamsSpec.$, PageHandler_GetOfficeMoveConfirmationShownForDrive_ResponseParamsSpec.$, this.getOfficeMoveConfirmationShownForDrive.createReceiverHandler(true /* expectsResponse */), false);
        this.getOfficeMoveConfirmationShownForOneDrive =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, PageHandler_GetOfficeMoveConfirmationShownForOneDrive_ParamsSpec.$, PageHandler_GetOfficeMoveConfirmationShownForOneDrive_ResponseParamsSpec.$, this.getOfficeMoveConfirmationShownForOneDrive.createReceiverHandler(true /* expectsResponse */), false);
        this.recordCancel =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, PageHandler_RecordCancel_ParamsSpec.$, null, this.recordCancel.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const DialogTaskSpec = { $: {} };
export const OneDriveSetupDialogArgsSpec = { $: {} };
export const MoveConfirmationOneDriveDialogArgsSpec = { $: {} };
export const MoveConfirmationGoogleDriveDialogArgsSpec = { $: {} };
export const ConnectToOneDriveDialogArgsSpec = { $: {} };
export const FileHandlerDialogArgsSpec = { $: {} };
export const DialogArgsSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_GetDialogArgs_ParamsSpec = { $: {} };
export const PageHandler_GetDialogArgs_ResponseParamsSpec = { $: {} };
export const PageHandler_IsOfficeWebAppInstalled_ParamsSpec = { $: {} };
export const PageHandler_IsOfficeWebAppInstalled_ResponseParamsSpec = { $: {} };
export const PageHandler_InstallOfficeWebApp_ParamsSpec = { $: {} };
export const PageHandler_InstallOfficeWebApp_ResponseParamsSpec = { $: {} };
export const PageHandler_IsODFSMounted_ParamsSpec = { $: {} };
export const PageHandler_IsODFSMounted_ResponseParamsSpec = { $: {} };
export const PageHandler_SignInToOneDrive_ParamsSpec = { $: {} };
export const PageHandler_SignInToOneDrive_ResponseParamsSpec = { $: {} };
export const PageHandler_RespondWithUserActionAndClose_ParamsSpec = { $: {} };
export const PageHandler_RespondWithLocalTaskAndClose_ParamsSpec = { $: {} };
export const PageHandler_SetOfficeAsDefaultHandler_ParamsSpec = { $: {} };
export const PageHandler_GetAlwaysMoveOfficeFilesToDrive_ParamsSpec = { $: {} };
export const PageHandler_GetAlwaysMoveOfficeFilesToDrive_ResponseParamsSpec = { $: {} };
export const PageHandler_SetAlwaysMoveOfficeFilesToDrive_ParamsSpec = { $: {} };
export const PageHandler_GetAlwaysMoveOfficeFilesToOneDrive_ParamsSpec = { $: {} };
export const PageHandler_GetAlwaysMoveOfficeFilesToOneDrive_ResponseParamsSpec = { $: {} };
export const PageHandler_SetAlwaysMoveOfficeFilesToOneDrive_ParamsSpec = { $: {} };
export const PageHandler_GetOfficeMoveConfirmationShownForDrive_ParamsSpec = { $: {} };
export const PageHandler_GetOfficeMoveConfirmationShownForDrive_ResponseParamsSpec = { $: {} };
export const PageHandler_GetOfficeMoveConfirmationShownForOneDrive_ParamsSpec = { $: {} };
export const PageHandler_GetOfficeMoveConfirmationShownForOneDrive_ResponseParamsSpec = { $: {} };
export const PageHandler_RecordCancel_ParamsSpec = { $: {} };
export const DialogSpecificArgsSpec = { $: {} };
mojo.internal.Struct(DialogTaskSpec.$, 'DialogTask', [
    mojo.internal.StructField('position', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('appId', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('iconUrl', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(OneDriveSetupDialogArgsSpec.$, 'OneDriveSetupDialogArgs', [
    mojo.internal.StructField('setOfficeAsDefaultHandler', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MoveConfirmationOneDriveDialogArgsSpec.$, 'MoveConfirmationOneDriveDialogArgs', [
    mojo.internal.StructField('operationType', 0, 0, OperationTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MoveConfirmationGoogleDriveDialogArgsSpec.$, 'MoveConfirmationGoogleDriveDialogArgs', [
    mojo.internal.StructField('operationType', 0, 0, OperationTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ConnectToOneDriveDialogArgsSpec.$, 'ConnectToOneDriveDialogArgs', [], [[0, 8],]);
mojo.internal.Struct(FileHandlerDialogArgsSpec.$, 'FileHandlerDialogArgs', [
    mojo.internal.StructField('localTasks', 0, 0, mojo.internal.Array(DialogTaskSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('showGoogleWorkspaceTask', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('showMicrosoftOfficeTask', 8, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(DialogArgsSpec.$, 'DialogArgs', [
    mojo.internal.StructField('fileNames', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('dialogSpecificArgs', 8, 0, DialogSpecificArgsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('handler', 0, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetDialogArgs_ParamsSpec.$, 'PageHandler_GetDialogArgs_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetDialogArgs_ResponseParamsSpec.$, 'PageHandler_GetDialogArgs_ResponseParams', [
    mojo.internal.StructField('args', 0, 0, DialogArgsSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_IsOfficeWebAppInstalled_ParamsSpec.$, 'PageHandler_IsOfficeWebAppInstalled_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_IsOfficeWebAppInstalled_ResponseParamsSpec.$, 'PageHandler_IsOfficeWebAppInstalled_ResponseParams', [
    mojo.internal.StructField('installed', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_InstallOfficeWebApp_ParamsSpec.$, 'PageHandler_InstallOfficeWebApp_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_InstallOfficeWebApp_ResponseParamsSpec.$, 'PageHandler_InstallOfficeWebApp_ResponseParams', [
    mojo.internal.StructField('installed', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_IsODFSMounted_ParamsSpec.$, 'PageHandler_IsODFSMounted_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_IsODFSMounted_ResponseParamsSpec.$, 'PageHandler_IsODFSMounted_ResponseParams', [
    mojo.internal.StructField('mounted', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SignInToOneDrive_ParamsSpec.$, 'PageHandler_SignInToOneDrive_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_SignInToOneDrive_ResponseParamsSpec.$, 'PageHandler_SignInToOneDrive_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RespondWithUserActionAndClose_ParamsSpec.$, 'PageHandler_RespondWithUserActionAndClose_Params', [
    mojo.internal.StructField('response', 0, 0, UserActionSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RespondWithLocalTaskAndClose_ParamsSpec.$, 'PageHandler_RespondWithLocalTaskAndClose_Params', [
    mojo.internal.StructField('taskPosition', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetOfficeAsDefaultHandler_ParamsSpec.$, 'PageHandler_SetOfficeAsDefaultHandler_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetAlwaysMoveOfficeFilesToDrive_ParamsSpec.$, 'PageHandler_GetAlwaysMoveOfficeFilesToDrive_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetAlwaysMoveOfficeFilesToDrive_ResponseParamsSpec.$, 'PageHandler_GetAlwaysMoveOfficeFilesToDrive_ResponseParams', [
    mojo.internal.StructField('alwaysMove', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetAlwaysMoveOfficeFilesToDrive_ParamsSpec.$, 'PageHandler_SetAlwaysMoveOfficeFilesToDrive_Params', [
    mojo.internal.StructField('alwaysMove', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetAlwaysMoveOfficeFilesToOneDrive_ParamsSpec.$, 'PageHandler_GetAlwaysMoveOfficeFilesToOneDrive_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetAlwaysMoveOfficeFilesToOneDrive_ResponseParamsSpec.$, 'PageHandler_GetAlwaysMoveOfficeFilesToOneDrive_ResponseParams', [
    mojo.internal.StructField('alwaysMove', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetAlwaysMoveOfficeFilesToOneDrive_ParamsSpec.$, 'PageHandler_SetAlwaysMoveOfficeFilesToOneDrive_Params', [
    mojo.internal.StructField('alwaysMove', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetOfficeMoveConfirmationShownForDrive_ParamsSpec.$, 'PageHandler_GetOfficeMoveConfirmationShownForDrive_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetOfficeMoveConfirmationShownForDrive_ResponseParamsSpec.$, 'PageHandler_GetOfficeMoveConfirmationShownForDrive_ResponseParams', [
    mojo.internal.StructField('moveConfirmationShown', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetOfficeMoveConfirmationShownForOneDrive_ParamsSpec.$, 'PageHandler_GetOfficeMoveConfirmationShownForOneDrive_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetOfficeMoveConfirmationShownForOneDrive_ResponseParamsSpec.$, 'PageHandler_GetOfficeMoveConfirmationShownForOneDrive_ResponseParams', [
    mojo.internal.StructField('moveConfirmationShown', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RecordCancel_ParamsSpec.$, 'PageHandler_RecordCancel_Params', [
    mojo.internal.StructField('page', 0, 0, MetricsRecordedSetupPageSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(DialogSpecificArgsSpec.$, 'DialogSpecificArgs', {
    'fileHandlerDialogArgs': {
        'ordinal': 0,
        'type': FileHandlerDialogArgsSpec.$,
    },
    'oneDriveSetupDialogArgs': {
        'ordinal': 1,
        'type': OneDriveSetupDialogArgsSpec.$,
    },
    'moveConfirmationOneDriveDialogArgs': {
        'ordinal': 2,
        'type': MoveConfirmationOneDriveDialogArgsSpec.$,
    },
    'moveConfirmationGoogleDriveDialogArgs': {
        'ordinal': 3,
        'type': MoveConfirmationGoogleDriveDialogArgsSpec.$,
    },
    'connectToOneDriveDialogArgs': {
        'ordinal': 4,
        'type': ConnectToOneDriveDialogArgsSpec.$,
    },
});
export var DialogSpecificArgsFieldTags;
(function (DialogSpecificArgsFieldTags) {
    DialogSpecificArgsFieldTags[DialogSpecificArgsFieldTags["FILE_HANDLER_DIALOG_ARGS"] = 0] = "FILE_HANDLER_DIALOG_ARGS";
    DialogSpecificArgsFieldTags[DialogSpecificArgsFieldTags["ONE_DRIVE_SETUP_DIALOG_ARGS"] = 1] = "ONE_DRIVE_SETUP_DIALOG_ARGS";
    DialogSpecificArgsFieldTags[DialogSpecificArgsFieldTags["MOVE_CONFIRMATION_ONE_DRIVE_DIALOG_ARGS"] = 2] = "MOVE_CONFIRMATION_ONE_DRIVE_DIALOG_ARGS";
    DialogSpecificArgsFieldTags[DialogSpecificArgsFieldTags["MOVE_CONFIRMATION_GOOGLE_DRIVE_DIALOG_ARGS"] = 3] = "MOVE_CONFIRMATION_GOOGLE_DRIVE_DIALOG_ARGS";
    DialogSpecificArgsFieldTags[DialogSpecificArgsFieldTags["CONNECT_TO_ONE_DRIVE_DIALOG_ARGS"] = 4] = "CONNECT_TO_ONE_DRIVE_DIALOG_ARGS";
})(DialogSpecificArgsFieldTags || (DialogSpecificArgsFieldTags = {}));
export function whichDialogSpecificArgs(u) {
    if (u.fileHandlerDialogArgs !== null && u.fileHandlerDialogArgs !== undefined) {
        return DialogSpecificArgsFieldTags.FILE_HANDLER_DIALOG_ARGS;
    }
    if (u.oneDriveSetupDialogArgs !== null && u.oneDriveSetupDialogArgs !== undefined) {
        return DialogSpecificArgsFieldTags.ONE_DRIVE_SETUP_DIALOG_ARGS;
    }
    if (u.moveConfirmationOneDriveDialogArgs !== null && u.moveConfirmationOneDriveDialogArgs !== undefined) {
        return DialogSpecificArgsFieldTags.MOVE_CONFIRMATION_ONE_DRIVE_DIALOG_ARGS;
    }
    if (u.moveConfirmationGoogleDriveDialogArgs !== null && u.moveConfirmationGoogleDriveDialogArgs !== undefined) {
        return DialogSpecificArgsFieldTags.MOVE_CONFIRMATION_GOOGLE_DRIVE_DIALOG_ARGS;
    }
    if (u.connectToOneDriveDialogArgs !== null && u.connectToOneDriveDialogArgs !== undefined) {
        return DialogSpecificArgsFieldTags.CONNECT_TO_ONE_DRIVE_DIALOG_ARGS;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
