import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style>#img-linux-illustration{align-self:center;height:180px;margin-bottom:80px;width:448px}#icon{height:32px;margin-top:28px;width:32px}#main{box-sizing:border-box;display:flex;flex-direction:column;height:608px;justify-content:space-between;padding:0 64px;width:768px}#title{color:var(--cr-primary-text-color);font-family:'Google Sans';font-size:28px;line-height:1;margin:41px 0 14px}#status-container{color:var(--cr-secondary-text-color);flex-grow:1;font-family:Roboto;font-size:13px;line-height:18px}paper-progress{--paper-progress-active-color:var(--google-blue-600);--paper-progress-container-color:rgba(var(--google-blue-600-rgb),.24);margin-top:31px;width:100%}#bottom-container{text-align:center}#button-container{display:flex;justify-content:flex-end;margin:32px 0}#labels{display:flex;flex-direction:row;justify-content:space-between}div.outer{align-items:stretch;display:flex;flex-direction:column}#configure-message-title{margin-bottom:41px}#configure-message{width:350px}#disk-size-section{margin-top:30px}#disk-size-section>div{margin-bottom:15px}a[href]{color:var(--cr-link-color);text-decoration:none}#low-free-space-warning{--iron-icon-fill-color:var(--google-yellow-500);display:flex}</style>

<div id="main">
  <img id="icon" src="images/crostini_icon.svg">
  <div id="status-container" role="status" aria-atomic="false">
    <div id="title">[[getTitle_(state_, error_)]]</div>

    <!-- Message containers. Depending on the current state, only one of them
      is visible. -->
    <div id="prompt-message" hidden="[[!eq_(state_, State.PROMPT)]]">
      <span>$i18n{promptMessage} </span>
      <a href="$i18n{learnMoreUrl}" target="_blank">$i18n{learnMore}</a>
    </div>
    <div id="configure-message" hidden="[[!eq_(state_, State.CONFIGURE)]]">
      <div id="configure-message-title">$i18n{configureMessage}</div>
      <cr-input label="$i18n{usernameLabel}" id="username" type="text"
          value="{{username_}}" maxlength="[[MAX_USERNAME_LENGTH]]"
          spellcheck="false"
          invalid="[[!eq_(usernameError_, '')]]"
          error-message="[[usernameError_]]">
      </cr-input>
      <div id='disk-size-section'>
        <div id="disk-size-message">
          <div style="color:var(--cr-primary-text-color)">
            $i18n{diskSizeSubtitle}
          </div>
          <div>$i18n{diskSizeHint}</div>
        </div>
        <template is="dom-if" if="[[!isLowSpaceAvailable_]]">
          <cr-radio-group selected="recommended"
              on-selected-changed="onDiskSizeRadioChanged_">
            <cr-radio-button name="recommended" id="recommended-size">
              $i18n{recommendedDiskSizeLabel}
            </cr-radio-button>
            <cr-radio-button name="custom" id="custom-size">
              $i18n{customDiskSizeLabel}
            </cr-radio-button>
          </cr-radio-group>
        </template>
        <template is="dom-if" if="[[isLowSpaceAvailable_]]">
          <div id='low-free-space-warning'>
            <iron-icon icon="cr:warning" class="warning"></iron-icon>
            $i18n{lowSpaceAvailableWarning}
          </div>
        </template>
        <template is="dom-if" if="[[showDiskSlider_]]">
          <div class="outer">
            <cr-slider id="diskSlider" pin="true"
                value="[[defaultDiskSizeTick_]]"
                aria-describedby="disk-size-message" ticks="[[diskSizeTicks_]]">
            </cr-slider>
            <div id="labels">
              <div id="label-begin">[[minDisk_]]</div>
              <div id="label-end">[[maxDisk_]]</div>
            </div>
          </div>
        </template>
      </div>
    </div>
    <div id="installing-message" hidden="[[!eq_(state_, State.INSTALLING)]]">
      <div>[[getProgressMessage_(installerState_)]]</div>
      <paper-progress class="progress-bar" value="[[installerProgress_]]">
      </paper-progress>
    </div>
    <div id="error-message" hidden="[[!showErrorMessage_(state_)]]">
      <div>[[errorMessage_]]</div>
    </div>
    <div id="canceling-message" hidden="[[!eq_(state_, State.CANCELING)]]">
      <div>$i18n{cancelingMessage}</div>
      <paper-progress class="progress-bar" indeterminate></paper-progress>
    </div>
  </div>
  <!-- TODO(crbug.com/40668830): Should show an error image for state "error".
      -->
  <img id="img-linux-illustration" src="images/linux_illustration.png" alt=""
      hidden="[[eq_(state_, State.CONFIGURE)]]">
  <div id="button-container">
    <cr-button class="cancel-button" on-click="onCancelButtonClick_"
        disabled="[[eq_(state_, State.CANCELING)]]">
      [[getCancelButtonLabel_(state_)]]
    </cr-button>
    <cr-button id="next" class="action-button" on-click="onNextButtonClick_"
        aria-describedby="title" aria-details="prompt-message"
        autofocus="true" hidden="[[!showNextButton_(state_)]]">
      $i18n{next}
    </cr-button>
    <cr-button
      id="install" class="action-button"
      on-click="onInstallButtonClick_" aria-describedby="title"
      aria-details="prompt-message"
      hidden="[[!showInstallButton_(state_, error_)]]"
      disabled="[[disableInstallButton_(state_, username_, usernameError_)]]">
      [[getInstallButtonLabel_(state_)]]
    </cr-button>
    <cr-button id="settings" class="action-button"
               on-click="onSettingsButtonClick_" aria-describedby="title"
               aria-details="prompt-message"
               hidden="[[!showSettingsButton_(state_, error_)]]">
      $i18n{settings}
    </cr-button>
  </div>
</div>
<!--_html_template_end_-->`}