// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/cr_input/cr_input.js";import"chrome://resources/ash/common/cr_elements/cr_slider/cr_slider.js";import"chrome://resources/ash/common/cr_elements/cr_radio_group/cr_radio_group.js";import"chrome://resources/ash/common/cr_elements/cr_radio_button/cr_radio_button.js";import"chrome://resources/ash/common/cr_elements/icons.html.js";import"chrome://resources/ash/common/cr_elements/cr_shared_vars.css.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import"chrome://resources/polymer/v3_0/paper-progress/paper-progress.js";import"/strings.m.js";import{assert,assertNotReached}from"chrome://resources/ash/common/assert.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{Polymer}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./app.html.js";import{BrowserProxy}from"./browser_proxy.js";import{InstallerError,InstallerState}from"./crostini_types.mojom-webui.js";const State={PROMPT:"prompt",CONFIGURE:"configure",INSTALLING:"installing",ERROR:"error",CANCELING:"canceling"};const MAX_USERNAME_LENGTH=32;const NoDiskSpaceError="no_disk_space";const UNAVAILABLE_USERNAMES=["root","daemon","bin","sys","sync","games","man","lp","mail","news","uucp","proxy","www-data","backup","list","irc","gnats","nobody","_apt","systemd-timesync","systemd-network","systemd-resolve","systemd-bus-proxy","messagebus","sshd","rtkit","pulse","android-root","chronos-access","android-everybody"];Polymer({is:"crostini-installer-app",_template:getTemplate(),properties:{state_:{type:String,value:State.PROMPT},error_:{type:String,value:InstallerError.kNone},installerState_:{type:Number},installerProgress_:{type:Number},errorMessage_:{type:String},State:{type:Object,value:State},minDisk_:{type:String},maxDisk_:{type:String},defaultDiskSizeTick_:{type:Number},diskSizeTicks_:{type:Array},chosenDiskSize_:{type:Number},isLowSpaceAvailable_:{type:Boolean},showDiskSlider_:{type:Boolean,value:false},username_:{type:String,value:loadTimeData.getString("defaultContainerUsername").substring(0,MAX_USERNAME_LENGTH),observer:"onUsernameChanged_"},usernameError_:{type:String},MAX_USERNAME_LENGTH:{type:Number,value:MAX_USERNAME_LENGTH}},attached(){const callbackRouter=BrowserProxy.getInstance().callbackRouter;this.listenerIds_=[callbackRouter.onProgressUpdate.addListener(((installerState,progressFraction)=>{this.installerState_=installerState;this.installerProgress_=progressFraction*100})),callbackRouter.onInstallFinished.addListener((error=>{if(error===InstallerError.kNone){this.closePage_()}else{assert(this.state_===State.INSTALLING);this.errorMessage_=this.getErrorMessage_(error);this.error_=error;this.state_=State.ERROR}})),callbackRouter.onCanceled.addListener((()=>this.closePage_())),callbackRouter.requestClose.addListener((()=>this.cancelOrBack_(true)))];this.diskSpacePromise_=BrowserProxy.getInstance().handler.requestAmountOfFreeDiskSpace();document.addEventListener("keyup",(event=>{if(event.key==="Escape"){this.cancelOrBack_();event.preventDefault()}}));this.$$(".action-button:not([hidden])").focus()},detached(){const callbackRouter=BrowserProxy.getInstance().callbackRouter;this.listenerIds_.forEach((id=>callbackRouter.removeListener(id)))},async onNextButtonClick_(){if(!this.onNextButtonClickIsRunning_){assert(this.state_===State.PROMPT);this.onNextButtonClickIsRunning_=true;const diskSpace=await this.diskSpacePromise_;const ticks=diskSpace.ticks;if(ticks.length===0){this.errorMessage_=loadTimeData.getString("minimumFreeSpaceUnmetError");this.error_=NoDiskSpaceError;this.state_=State.ERROR;this.onNextButtonClickIsRunning_=false;return}this.defaultDiskSizeTick_=diskSpace.defaultIndex;this.diskSizeTicks_=ticks;this.minDisk_=ticks[0].label;this.maxDisk_=ticks[ticks.length-1].label;this.isLowSpaceAvailable_=diskSpace.isLowSpaceAvailable;if(this.isLowSpaceAvailable_){this.showDiskSlider_=true}this.state_=State.CONFIGURE;this.$.username.select(this.username_.length,this.username_.length);this.onNextButtonClickIsRunning_=false}},onInstallButtonClick_(){assert(this.showInstallButton_(this.state_,this.error_));let diskSize=0;if(this.showDiskSlider_){diskSize=this.diskSizeTicks_[this.$$("#diskSlider").value].value}else{diskSize=this.diskSizeTicks_[this.defaultDiskSizeTick_].value}this.installerState_=InstallerState.kStart;this.installerProgress_=0;this.state_=State.INSTALLING;BrowserProxy.getInstance().handler.install(diskSize,this.username_)},onSettingsButtonClick_(){window.open("chrome://os-settings/help")},onCancelButtonClick_(){this.cancelOrBack_()},cancelOrBack_(forceCancel=false){switch(this.state_){case State.PROMPT:BrowserProxy.getInstance().handler.cancelBeforeStart();this.closePage_();break;case State.CONFIGURE:if(forceCancel){this.closePage_()}else{this.state_=State.PROMPT}break;case State.INSTALLING:this.state_=State.CANCELING;BrowserProxy.getInstance().handler.cancel();break;case State.ERROR:this.closePage_();break;case State.CANCELING:break;default:assertNotReached()}},closePage_(){BrowserProxy.getInstance().handler.onPageClosed()},getTitle_(state,error){let titleId;switch(state){case State.PROMPT:case State.CONFIGURE:titleId="promptTitle";break;case State.INSTALLING:titleId="installingTitle";break;case State.ERROR:if(error==InstallerError.kNeedUpdate){titleId="needUpdateTitle"}else{titleId="errorTitle"}break;case State.CANCELING:titleId="cancelingTitle";break;default:assertNotReached()}return loadTimeData.getString(titleId)},eq_(value1,value2){return value1===value2},showInstallButton_(state,error){return state===State.CONFIGURE||state===State.ERROR&&error!==NoDiskSpaceError&&error!=InstallerError.kNeedUpdate},disableInstallButton_(state,username,usernameError){if(state===State.CONFIGURE){return!username||!!usernameError}return false},showNextButton_(state){return state===State.PROMPT},showSettingsButton_(state,error){return state===State.ERROR&&error==InstallerError.kNeedUpdate},getInstallButtonLabel_(state){switch(state){case State.CONFIGURE:return loadTimeData.getString("install");case State.ERROR:return loadTimeData.getString("retry");default:return""}},getProgressMessage_(installerState){let messageId=null;switch(installerState){case InstallerState.kStart:break;case InstallerState.kInstallImageLoader:messageId="loadTerminaMessage";break;case InstallerState.kCreateDiskImage:messageId="createDiskImageMessage";break;case InstallerState.kStartTerminaVm:messageId="startTerminaVmMessage";break;case InstallerState.kStartLxd:messageId="startLxdMessage";break;case InstallerState.kCreateContainer:case InstallerState.kSetupContainer:messageId="setupContainerMessage";break;case InstallerState.kStartContainer:messageId="startContainerMessage";break;case InstallerState.kConfigureContainer:messageId="configureContainerMessage";break;default:assertNotReached()}return messageId?loadTimeData.getString(messageId):""},getErrorMessage_(error){let messageId=null;switch(error){case InstallerError.kErrorLoadingTermina:messageId="loadTerminaError";break;case InstallerError.kNeedUpdate:messageId="needUpdateError";break;case InstallerError.kErrorCreatingDiskImage:messageId="createDiskImageError";break;case InstallerError.kErrorStartingTermina:messageId="startTerminaVmError";break;case InstallerError.kErrorStartingLxd:messageId="startLxdError";break;case InstallerError.kErrorStartingContainer:messageId="startContainerError";break;case InstallerError.kErrorConfiguringContainer:messageId="configureContainerError";break;case InstallerError.kErrorOffline:messageId="offlineError";break;case InstallerError.kErrorSettingUpContainer:messageId="setupContainerError";break;case InstallerError.kErrorInsufficientDiskSpace:messageId="insufficientDiskError";break;case InstallerError.kErrorCreateContainer:messageId="setupContainerError";break;case InstallerError.kErrorUnknown:messageId="unknownError";break;default:assertNotReached()}return messageId?loadTimeData.getString(messageId):""},onUsernameChanged_(username,oldUsername){if(!username){this.usernameError_=""}else if(UNAVAILABLE_USERNAMES.includes(username)){this.usernameError_=loadTimeData.getStringF("usernameNotAvailableError",username)}else if(!/^[a-z_]/.test(username)){this.usernameError_=loadTimeData.getString("usernameInvalidFirstCharacterError")}else if(!/^[a-z0-9_-]*$/.test(username)){this.usernameError_=loadTimeData.getString("usernameInvalidCharactersError")}else{this.usernameError_=""}},getCancelButtonLabel_(state){return loadTimeData.getString(state===State.CONFIGURE?"back":"cancel")},showErrorMessage_(state){return state===State.ERROR},onDiskSizeRadioChanged_(event){this.showDiskSlider_=event.detail.value!=="recommended"||!!this.isLowSpaceAvailable_}});