import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style>#error-log{white-space:pre}#img-rect-illustration{align-self:center;height:180px;margin-bottom:80px;width:448px}#img-square-illustration{align-self:center;height:180px;margin-bottom:80px;width:180px}#icon{height:32px;margin-top:28px;width:32px}#main{box-sizing:border-box;display:flex;flex-direction:column;height:608px;justify-content:space-between;padding:0 64px;width:768px}#main-title{color:var(--cros-text-color-primary);font-family:'Google Sans';font-size:28px;line-height:1;margin:36px 0 14px}#status-container{color:var(--cros-text-color-secondary);flex-grow:1;font-family:Roboto;font-size:13px;line-height:18px}#progress-message{height:36px}#progress-submessage{color:var(--google-grey-600);flex-grow:1;font-family:Roboto;font-size:13px;line-height:18px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}paper-progress{--paper-progress-active-color:var(--cros-icon-color-prominent);--paper-progress-container-color:rgba(var(--google-blue-600-rgb),.24);margin-top:36px;width:100%}#log-storage-message{color:var(--cros-text-color-secondary);flex-grow:1;font-family:Roboto;font-size:13px;line-height:18px}#bottom-container{text-align:center}#button-container{display:flex;gap:8px;justify-content:flex-end;margin:32px 0}a[href]{color:var(--cr-link-color);text-decoration:none}</style>

<div id="main">
  <img id="icon" src="images/crostini_icon.svg">
  <div id="status-container" role="status" aria-atomic="false">
    <div id="main-title">[[getTitle_(state_)]]</div>

    <!-- Prompt/Progress message. Use inner-h-t-m-l because some
         messages contain links. -->
    <div id="progress-message">
      <span inner-h-t-m-l=
            "[[getProgressMessage_(state_, precheckStatus_, logFileName_)]]">
      </span>
      <!-- Progress submessage. -->
      <div id = "progress-submessage"
           hidden="[[!isState_(state_, State.UPGRADING)]]">
        <span>[[lastProgressLine_]]</span>
      </div>
    </div>
    <!-- Progress bar containers. Depending on the current state, only one
      of them is visible. -->
    <div id="backup-progress-bar"  hidden="[[!isState_(state_, State.BACKUP)]]">
      <paper-progress class="progress-bar" value="[[backupProgress_]]">
      </paper-progress>
    </div>
    <div id="restore-progress-bar"
        hidden="[[!isState_(state_, State.RESTORE)]]">
      <paper-progress class="progress-bar" value="[[restoreProgress_]]">
      </paper-progress>
    </div>
    <div id="upgrade-progress-bar"
        hidden="[[!isState_(state_, State.UPGRADING)]]">
      <paper-progress class="progress-bar" indeterminate>
      </paper-progress>
    </div>
    <div id="canceling-progress-bar"
        hidden="[[!isState_(state_, State.CANCELING)]]">
      <paper-progress class="progress-bar" indeterminate></paper-progress>
    </div>
    <div id="upgrade-error-message" hidden="[[isErrorLogsHidden_(state_)]]">
      <textarea id="error-log" rows="20" cols="80" readonly>[[getErrorLogs_(state_)]]</textarea>
    </div>
  </div>

  <img id="[[getIllustrationStyle_(state_)]]"
      src="[[getIllustrationURI_(state_)]]" alt=""
      hidden="[[hideIllustration_(state_)]]">
  <div id="backup-checkbox" hidden="[[!isState_(state_, State.PROMPT)]]">
    <cr-checkbox checked="{{backupCheckboxChecked_}}" >
      <p class="checkbox-text">
        $i18n{backupCheckboxMessage}
        <a href="#" on-click="onChangeLocationButtonClick_"
            style="text-decoration: none">
        $i18n{backupChangeLocation}</a>
      </p>
    </cr-checkbox>
  </div>
  <div id="button-container">
    <cr-button id="cancel-button" on-click="onCancelButtonClick_"
        hidden="[[!canCancel_(state_)]]">
      [[getCancelButtonLabel_(state_)]]
    </cr-button>
    <cr-button class="action-button" on-click="onActionButtonClick_"
        aria-describedby="title" aria-details="prompt-message"
        hidden="[[!canDoAction_(state_)]]">
      [[getActionButtonLabel_(state_)]]
    </cr-button>
  </div>
</div>
<!--_html_template_end_-->`;
}
