import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style>.button-group>cr-button{margin-inline-start:10px}.list{font-size:16px}#select-div{display:flex;height:400px;width:500px}iron-pages{flex:1;position:relative}table,th,td{border:1px solid black;border-collapse:collapse;padding:3px;margin-top:5px;margin-bottom:5px}li{margin-top:10px}</style>

<template is="dom-if" if="[[isOtr_]]">
  <p>Data Leak Prevention policy is disabled in off-the-record contexts.</p>
</template>

<template is="dom-if" if="[[!doRulesManagerExist_]]">
  <p>The Rules Manager of Data Leak Prevention policy doesn\'t exist.</p>
</template>

<template is="dom-if" if="[[showTabs_]]">
  <cr-tabs tab-names="[[tabNames_]]" selected="{{selectedTabIdx_}}"> </cr-tabs>
  <iron-pages selected="[[selectedTabIdx_]]">
    <div class="tabpanel" id="clipboard">
      <ul class="list">
        <li>Clipboard data source Type: [[clipboardSourceType_]]</li>
        <li>Clipboard data source URL: [[clipboardSourceUrl_]]</li>
      </ul>
    </div>

    <div class="tabpanel" id="oncontent">
      <ol>
        <template is="dom-repeat" items="[[webContentsElements_]]">
          <li>
            <div>
              <b>Web Content URL: </b>[[item.info_.lastCommittedUrl.url]]
            </div>
            <table>
              <tr>
                <th>Restriction</th>
                <th>Level</th>
                <th>URL</th>
              </tr>
              <template is="dom-repeat" items="[[item.info_.restrictionsInfo]]">
                <tr>
                  <td>[[contentRestrictionToString(item.restriction)]]</td>
                  <td>[[levelToString(item.level)]]</td>
                  <td>[[item.url.url]]</td>
                </tr>
              </template>
            </table>
            <cr-expand-button expanded="{{item.framesExpanded_}}">
              <div hidden$="[[item.framesExpanded_]]">Expand Frames Info</div>
              <div hidden$="[[!item.framesExpanded_]]">
                Collapse Frames Info
              </div>
            </cr-expand-button>
            <iron-collapse opened="[[item.framesExpanded_]]">
              <ul>
                <template is="dom-repeat" items="[[item.info_.framesInfo]]">
                  <li>
                    <div>
                      <b>Frame URL: </b>[[item.lastCommittedUrl.url]]
                    </div>
                    <table>
                      <tr>
                        <th>Restriction</th>
                        <th>Level</th>
                        <th>URL</th>
                      </tr>
                      <template is="dom-repeat" items="[[item.restrictionsInfo]]">
                        <tr>
                          <td>
                            [[contentRestrictionToString(item.restriction)]]
                          </td>
                          <td>[[levelToString(item.level)]]</td>
                          <td>[[item.url.url]]</td>
                        </tr>
                      </template>
                  </li>
                </template>
              </ul>
            </iron-collapse>
          </li>
        </template>
      </ol>
    </div>

    <div class="tabpanel" id="files">
        <table>
          <tr>
            <th>inode</th>
            <th>Creation Time</th>
            <th>Source URL</th>
            <th>Referrer URL</th>
          </tr>
          <template is="dom-repeat" items="[[filesEntries_]]">
            <tr>
              <td>[[item.inode]]</td>
              <td>[[creationTimeToString(item.crtime)]]</td>
              <td>[[item.sourceUrl]]</td>
              <td>[[item.referrerUrl]]</td>
            </tr>
          </template>
        </table>
      <div>
        <p>Select a file from Downloads to calculate its inode number</p>
        <label>
          <input type="file" accept="any" on-input="onFileSelected">
        </label>
        <p>inode number: [[selectedFileInode_]]</p>
        <span></span>
      </div>
    </div>

    <div class="tabpanel" id="reporting">
      <table>
        <tr>
          <th>Source Pattern</th>
          <th>Destination</th>
          <th>Restriction</th>
          <th>Mode</th>
          <th>User Type</th>
          <th>Content Name</th>
          <th>Rule Name</th>
          <th>Rule ID</th>
          <th>Timestamp (micro)</th>
        </tr>
        <template is="dom-repeat" items="[[reportingEvents_]]">
          <tr>
            <td>[[item.sourcePattern]]</td>
            <td>[[destinationToString(item.destination)]]</td>
            <td>[[restrictionToString(item.restriction)]]</td>
            <td>[[modeToString(item.mode)]]</td>
            <td>[[userTypeToString(item.userType)]]</td>
            <td>[[item.contentName]]</td>
            <td>[[item.triggeredRuleName]]</td>
            <td>[[item.triggeredRuleId]]</td>
            <td>[[timestampToString(item.timestampMicro)]]</td>
          </tr>
        </template>
      </table>
    </div>
  </iron-pages>
</template>
<!--_html_template_end_-->`}