// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./common.css.js";import"./edu_coexistence_template.js";import"./edu_coexistence_button.js";import"chrome://chrome-signin/gaia_action_buttons/gaia_action_buttons.js";import"chrome://resources/polymer/v3_0/paper-spinner/paper-spinner-lite.js";import{assert}from"chrome://resources/ash/common/assert.js";import{WebUiListenerMixin}from"chrome://resources/ash/common/cr_elements/web_ui_listener_mixin.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{EduCoexistenceBrowserProxyImpl}from"./edu_coexistence_browser_proxy.js";import{EduCoexistenceController}from"./edu_coexistence_controller.js";import{getTemplate}from"./edu_coexistence_ui.html.js";const EduCoexistenceUiBase=WebUiListenerMixin(PolymerElement);export class EduCoexistenceUi extends EduCoexistenceUiBase{static get is(){return"edu-coexistence-ui"}static get template(){return getTemplate()}static get properties(){return{loading:{type:Boolean,value:true},showGaiaButtons:{type:Boolean,value:false},showGaiaNextButton:{type:Boolean,value:false},controller:Object}}ready(){super.ready();this.addWebUiListener("load-authenticator",(data=>this.loadAuthenticator(data)));this.webview=this.$.signinFrame;this.webview.addEventListener("loadabort",(()=>{this.loading=false;this.showError()}));EduCoexistenceBrowserProxyImpl.getInstance().initializeEduArgs().then((data=>{this.controller=new EduCoexistenceController(this,assert(this.webview),data);EduCoexistenceBrowserProxyImpl.getInstance().initializeLogin()}),(()=>{this.showError();EduCoexistenceBrowserProxyImpl.getInstance().onError(["There was an error getting edu coexistence data"])}))}setWebviewForTest(webview){this.webview=webview}showError(){this.dispatchEvent(new CustomEvent("go-error",{bubbles:true,composed:true}))}loadAuthenticator(data){this.controller.loadAuthenticator(data);this.webview.addEventListener("contentload",(()=>{this.loading=false;this.configureUiForGaiaFlow()}))}handleGaiaLoginGoBack(e){e.stopPropagation();const backButton=this.shadowRoot.querySelector("#gaia-back-button");if(backButton.disabled){return}backButton.disabled=true;this.webview.back((()=>{setTimeout((()=>{backButton.disabled=false}),1e3);this.webview.focus()}))}configureUiForGaiaFlow(){const currentUrl=new URL(this.webview.src);const template=this.shadowRoot.querySelector("edu-coexistence-template");const contentContainer=template.shadowRoot.querySelector(".content-container");if(currentUrl.hostname!==this.controller.getFlowOriginHostname()){this.showGaiaButtons=true;contentContainer.style.height="calc(100% - 90px)";this.showGaiaNextButton=currentUrl.hostname.endsWith(".google.com")}else{this.showGaiaButtons=false;this.showGaiaNextButton=false;contentContainer.style.height="100%"}template.updateButtonFooterVisibility(this.showGaiaButtons)}}customElements.define(EduCoexistenceUi.is,EduCoexistenceUi);