// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { sendWithPromise } from 'chrome://resources/ash/common/cr.m.js';
export class EduCoexistenceBrowserProxyImpl {
    initializeLogin() {
        chrome.send('initialize');
    }
    initializeEduArgs() {
        return sendWithPromise('initializeEduArgs');
    }
    authenticatorReady() {
        chrome.send('authenticatorReady');
    }
    completeLogin(credentials) {
        chrome.send('completeLogin', [credentials]);
    }
    getAccounts() {
        return sendWithPromise('getAccounts');
    }
    getDeviceId() {
        return sendWithPromise('getDeviceId');
    }
    consentValid() {
        chrome.send('consentValid');
    }
    consentLogged(account, eduCoexistenceToSVersion) {
        return sendWithPromise('consentLogged', [account, eduCoexistenceToSVersion]);
    }
    dialogClose() {
        chrome.send('dialogClose');
    }
    onError(msg) {
        chrome.send('error', msg);
    }
    static getInstance() {
        return instance || (instance = new EduCoexistenceBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
let instance = null;
