import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style>:host{margin-top:10px;position:relative;--emoji-background:transparent}:host([category="emoticon"]),:host([category="symbol"]){--emoji-button-border-radius:4px}.emoji-button{background:var(--emoji-background);border:none;cursor:pointer;height:100%}.emoji-button-container{height:var(--emoji-size);position:relative;width:var(--emoji-size)}.grid-layout{display:grid;gap:var(--emoji-spacing);grid-auto-rows:max-content;grid-template-columns:repeat(var(--emoji-per-row),1fr);justify-items:center}.grid-layout .emoji-button{border-radius:var(--emoji-button-border-radius,50%);display:block;font-family:'Noto Color Emoji';font-size:19px;line-height:var(--emoji-size);outline:none;padding:0;text-align:center;user-select:none;width:100%}.flex-layout{display:flex;flex-wrap:wrap;gap:12px 20px}.flex-layout .emoji-button-container{width:max-content}.flex-layout .emoji-button{border-radius:var(--emoji-button-border-radius,0);color:var(--emoji-picker-symbol-color);font-family:'Noto Sans CJK JP';font-size:13px;padding:6px;width:max-content}.two-column-layout{display:flex}.two-column-layout .left-column{flex:50%}.two-column-layout .right-column{align-items:flex-end;display:flex;flex:50%;flex-direction:column}#heading{color:var(--emoji-picker-category-header-color);display:flex;font-size:13px;padding-bottom:var(--emoji-group-heading-padding-bottom);padding-top:var(--emoji-group-heading-padding-top)}#heading:focus,#heading:active{outline-color:var(--emoji-picker-focus-ring-color);outline-width:2px}#heading-left{height:var(--emoji-group-heading-size);line-height:var(--emoji-group-heading-size);user-select:none;width:100%}#palette{padding-bottom:16px}#show-clear{--cr-icon-button-fill-color:var(--emoji-picker-icon-button-icon-color);--cr-icon-button-focus-outline-color:var(--emoji-picker-focus-ring-color);height:var(--emoji-group-heading-size);left:var(--emoji-picker-last-emoji-left);margin:0;width:var(--emoji-group-heading-size)}#clear-recents-container{position:absolute;right:0;top:calc(var(--emoji-group-heading-padding-top) + var(--emoji-group-heading-padding-bottom) + var(--emoji-group-heading-size));box-shadow:var(--cros-elevation-1-shadow);border-radius:4px;overflow:hidden;z-index:300}#clear-recents,#help{background-color:var(--emoji-picker-container-color);border:2px solid transparent;color:var(--cros-text-color-secondary);cursor:pointer;font-family:'Roboto',sans-serif;font-size:12px;height:var(--emoji-size);outline:none;padding:0;white-space:nowrap;width:100%;z-index:200;display:block;text-align:left}#clear-recents:focus,#clear-recents:active,#help:focus,#help:active{border:2px solid var(--cros-toggle-color)}#fake-focus-target{position:absolute}#clear-recents-hover{border:2px solid transparent;margin:-2px;padding:7px 11px 7px 11px}#clear-recents-hover:hover{background-color:var(--cros-button-background-color-secondary-hover);border:2px solid var(--cros-button-background-color-secondary-hover)}.emoji-button:focus,.emoji-button:active{outline-color:var(--emoji-picker-focus-ring-color);outline-style:solid;outline-width:2px}.emoji-button:disabled{color:red;cursor:default}.emoji-button:hover{background-color:var(--emoji-hover-background)}[has-variants]::after{background:linear-gradient(315deg,var(--google-grey-500) 4px,var(--emoji-background) 4px,var(--emoji-background));content:'';display:block;height:var(--emoji-size);position:relative;top:calc(0px - var(--emoji-size));width:var(--emoji-size)}paper-tooltip{--paper-tooltip-background:var(--cros-tooltip-background-color);--paper-tooltip-delay-in:var(--emoji-tooltip-delay-in);--paper-tooltip-delay-out:var(--emoji-tooltip-delay-out);--paper-tooltip-duration-in:0;--paper-tooltip-duration-out:0;--paper-tooltip-opacity:1;--paper-tooltip-text-color:var(--cros-tooltip-label-color)}paper-tooltip::part(tooltip){box-shadow:var(--cros-elevation-1-shadow);font-family:'Roboto',sans-serif;font-size:12px;margin:4px;padding:4px 8px 4px 8px;white-space:nowrap}</style>

<!-- Add header section. -->
<template is="dom-if" if="[[group]]">
  <div id="heading" role="heading" aria-level="2" tabindex="-1">
    <div id="heading-left">[[group]]</div>
    <template is="dom-if" if="[[clearable]]">
      <cr-icon-button id="show-clear" iron-icon="emoji_picker:more_horizontal"
        on-click="onClearClick"
        aria-label$="[[getMoreOptionsAriaLabel(gifSupport)]]">
      </cr-icon-button>
    </template>
  </div>
</template>
<template is = "dom-if" if="[[showClearRecents]]">
  <div id="clear-recents-container">
    <button id="clear-recents" on-click="onClearRecentsClick">
      <div id="clear-recents-hover">
        Clear recently used [[formatCategory(category)]]s
      </div>
    </button>

    <button id="help" on-click="onHelpClick">
      <div id="clear-recents-hover">
        Help
      </div>
    </button>
</div>
</template>

<!-- Add emoji buttons.
  Note that the click and context menu listeners are shared among all the
  elements to improve efficiency and performance.

  Note duplicate loop for case with and without variants. Since many categories
  have zero variants, doing the variants on a per-group basis has a significant
  advantage.
-->
<div id="palette"
  class$="[[getLayoutClassName(layoutType, category)]]"
  on-click="onEmojiClick"
  on-contextmenu="onEmojiContextMenu">
  <div id="fake-focus-target" tabindex="-1"></div>
  <template is="dom-if" if="[[isVisual(category)]]">
    <div class="left-column">
      <template is="dom-repeat" items="[[filterColumn(data, 'left', data.length)]]">
        <emoji-image index="[[getIndex(item)]]"
          item="[[item]]"
          show-tooltip="[[showTooltip]]"
          emoji-click="[[onEmojiClick]]"
          clearable="[[clearable]]">
        </emoji-image>
      </template>
    </div>
    <div class="right-column">
      <template is="dom-repeat" items="[[filterColumn(data, 'right', data.length)]]">
        <emoji-image index="[[getIndex(item)]]"
          item="[[item]]"
          show-tooltip="[[showTooltip]]"
          emoji-click="[[onEmojiClick]]"
          clearable="[[clearable]]">
        </emoji-image>
      </template>
    </div>
  </template>
  <template is="dom-if" if="[[!isVisual(category)]]">
    <template is="dom-if" if="[[hasAnyVariants(data)]]">
      <template is="dom-repeat" items="[[data]]">
        <div class="emoji-button-container">
        <button id="emoji-[[index]]" data-index$="[[index]]"
          class="emoji-button" has-variants$="[[hasVariants(item)]]"
          on-mouseenter="showTooltip" on-focus="showTooltip"
          aria-label="[[getEmojiAriaLabel(item)]]">
          [[getDisplayEmojiForEmoji(item.base.string, item)]]
        </button>
        <template is="dom-if"
          if="[[isEmojiVariantVisible(index,shownEmojiVariantIndex)]]">
          <emoji-variants
            id="emoji-variant-[[index]]"
            variants="[[item.alternates]]"
            grouped-tone="[[item.groupedTone]]"
            grouped-gender="[[item.groupedGender]]"
            tooltip="[[item.base.name]]">
          </emoji-variants>
        </template>
        </div>
      </template>
    </template>
    <template is="dom-if" if="[[!hasAnyVariants(data)]]">
      <template is="dom-repeat" items="[[data]]">
        <div class="emoji-button-container">
        <button id="emoji-[[index]]" data-index$="[[index]]"
          class="emoji-button"
          on-mouseenter="showTooltip" on-focus="showTooltip"
          aria-label="[[getEmojiAriaLabel(item)]]">
          [[getDisplayEmojiForEmoji(item.base.string, item)]]
        </button>
        </div>
      </template>
    </template>
  </template>
  <paper-tooltip id='tooltip' fit-to-visible-bounds offset="8">
    [[focusedEmoji.base.name]]
  </paper-tooltip>
</div>
<!--_html_template_end_-->`;
}
