import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style>.emoji-image-container{position:relative}.emoji-image{background-color:var(--cros-button-stroke-color-secondary-disabled);border:none;border-radius:8px;cursor:pointer;display:block;height:var(--visual-content-height);margin-bottom:var(--visual-content-padding);width:var(--visual-content-width)}.emoji-image:focus,.emoji-image:active{outline-color:var(--emoji-picker-focus-ring-color);outline-style:solid;outline-width:2px}.emoji-image:hover{background-color:var(--emoji-hover-background)}.emoji-image.loading{animation:loading-rect-loop 1500ms;animation-iteration-count:infinite}@keyframes loading-rect-loop{0%{opacity:1}50%{opacity:0.5}100%{opacity:1}}.emoji-image-clear{background-color:var(--emoji-picker-container-color);border:2px solid transparent;border-radius:4px;box-shadow:var(--cros-elevation-1-shadow);color:var(--cros-text-color-secondary);cursor:pointer;font:var(--cros-button-2-font);outline:none;padding:7px 11px 7px 11px;position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);white-space:nowrap;width:fit-content;z-index:200}.emoji-image-clear:focus,.emoji-image-clear:active{border:2px solid var(--cros-toggle-color)}
</style>

<div class="emoji-image-container"
  on-contextmenu="handleContextMenu"
  on-mouseleave="handleMouseLeave"
  style$="[[getStyles(item)]]">

  <img data-index$="[[index]]"
    class$="[[getImageClassName(loading)]]"
    is="cr-auto-img"
    auto-src="[[getUrl(item)]]"
    alt$="[[item.base.name]]"
    load="lazy"
    on-mouseenter="handleMouseEnter"
    on-focus="handleFocus"
    on-click="handleClick"
    on-keydown="handleKeydown"
    on-load="handleLoad"
    role="button"
    tabindex="0">

  <template is="dom-if" if="[[showClearButton]]">
    <button class="emoji-image-clear" on-click="handleClear">
      Remove from recently used GIFs
    </button>
  </template>
</div><!--_html_template_end_-->`;
}
