// chrome/browser/ui/webui/ash/emoji/emoji_picker.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { StatusSpec as tenor_mojom_StatusSpec, GifResponseSpec as tenor_mojom_GifResponseSpec, PaginatedGifResponsesSpec as tenor_mojom_PaginatedGifResponsesSpec } from './tenor_types.mojom-webui.js';
import { JSTimeSpec as mojoBase_mojom_JSTimeSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const FeatureSpec = { $: mojo.internal.Enum() };
export var Feature;
(function (Feature) {
    Feature[Feature["MIN_VALUE"] = 0] = "MIN_VALUE";
    Feature[Feature["MAX_VALUE"] = 6] = "MAX_VALUE";
    Feature[Feature["EMOJI_PICKER_EXTENSION"] = 0] = "EMOJI_PICKER_EXTENSION";
    Feature[Feature["EMOJI_PICKER_SEARCH_EXTENSION"] = 1] = "EMOJI_PICKER_SEARCH_EXTENSION";
    Feature[Feature["EMOJI_PICKER_GIF_SUPPORT"] = 2] = "EMOJI_PICKER_GIF_SUPPORT";
    Feature[Feature["EMOJI_PICKER_VARIANT_GROUPING_SUPPORT"] = 5] = "EMOJI_PICKER_VARIANT_GROUPING_SUPPORT";
    Feature[Feature["EMOJI_PICKER_MOJO_SEARCH"] = 6] = "EMOJI_PICKER_MOJO_SEARCH";
})(Feature || (Feature = {}));
export const CategorySpec = { $: mojo.internal.Enum() };
export var Category;
(function (Category) {
    Category[Category["MIN_VALUE"] = 0] = "MIN_VALUE";
    Category[Category["MAX_VALUE"] = 3] = "MAX_VALUE";
    Category[Category["kEmojis"] = 0] = "kEmojis";
    Category[Category["kSymbols"] = 1] = "kSymbols";
    Category[Category["kEmoticons"] = 2] = "kEmoticons";
    Category[Category["kGifs"] = 3] = "kGifs";
})(Category || (Category = {}));
export class PageHandlerFactoryPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'emoji_picker.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "emoji_picker.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'emoji_picker.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    showUI() {
        this.proxy.sendMessage(0, PageHandler_ShowUI_ParamsSpec.$, null, [], false);
    }
    insertEmoji(emoji, isVariant, searchLength) {
        this.proxy.sendMessage(1, PageHandler_InsertEmoji_ParamsSpec.$, null, [
            emoji,
            isVariant,
            searchLength
        ], false);
    }
    insertGif(gif) {
        this.proxy.sendMessage(2, PageHandler_InsertGif_ParamsSpec.$, null, [
            gif
        ], false);
    }
    isIncognitoTextField() {
        return this.proxy.sendMessage(3, PageHandler_IsIncognitoTextField_ParamsSpec.$, PageHandler_IsIncognitoTextField_ResponseParamsSpec.$, [], false);
    }
    getFeatureList() {
        return this.proxy.sendMessage(4, PageHandler_GetFeatureList_ParamsSpec.$, PageHandler_GetFeatureList_ResponseParamsSpec.$, [], false);
    }
    getCategories() {
        return this.proxy.sendMessage(5, PageHandler_GetCategories_ParamsSpec.$, PageHandler_GetCategories_ResponseParamsSpec.$, [], false);
    }
    getFeaturedGifs(pos) {
        return this.proxy.sendMessage(6, PageHandler_GetFeaturedGifs_ParamsSpec.$, PageHandler_GetFeaturedGifs_ResponseParamsSpec.$, [
            pos
        ], false);
    }
    searchGifs(query, pos) {
        return this.proxy.sendMessage(7, PageHandler_SearchGifs_ParamsSpec.$, PageHandler_SearchGifs_ResponseParamsSpec.$, [
            query,
            pos
        ], false);
    }
    getGifsByIds(ids) {
        return this.proxy.sendMessage(8, PageHandler_GetGifsByIds_ParamsSpec.$, PageHandler_GetGifsByIds_ResponseParamsSpec.$, [
            ids
        ], false);
    }
    onUiFullyLoaded() {
        this.proxy.sendMessage(9, PageHandler_OnUiFullyLoaded_ParamsSpec.$, null, [], false);
    }
    getInitialCategory() {
        return this.proxy.sendMessage(10, PageHandler_GetInitialCategory_ParamsSpec.$, PageHandler_GetInitialCategory_ResponseParamsSpec.$, [], false);
    }
    getInitialQuery() {
        return this.proxy.sendMessage(11, PageHandler_GetInitialQuery_ParamsSpec.$, PageHandler_GetInitialQuery_ResponseParamsSpec.$, [], false);
    }
    updateHistoryInPrefs(category, history) {
        this.proxy.sendMessage(12, PageHandler_UpdateHistoryInPrefs_ParamsSpec.$, null, [
            category,
            history
        ], false);
    }
    updatePreferredVariantsInPrefs(preferredVariants) {
        this.proxy.sendMessage(13, PageHandler_UpdatePreferredVariantsInPrefs_ParamsSpec.$, null, [
            preferredVariants
        ], false);
    }
    getHistoryFromPrefs(category) {
        return this.proxy.sendMessage(14, PageHandler_GetHistoryFromPrefs_ParamsSpec.$, PageHandler_GetHistoryFromPrefs_ResponseParamsSpec.$, [
            category
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_ShowUI_ParamsSpec.$, null, impl.showUI.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_InsertEmoji_ParamsSpec.$, null, impl.insertEmoji.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_InsertGif_ParamsSpec.$, null, impl.insertGif.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_IsIncognitoTextField_ParamsSpec.$, PageHandler_IsIncognitoTextField_ResponseParamsSpec.$, impl.isIncognitoTextField.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_GetFeatureList_ParamsSpec.$, PageHandler_GetFeatureList_ResponseParamsSpec.$, impl.getFeatureList.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_GetCategories_ParamsSpec.$, PageHandler_GetCategories_ResponseParamsSpec.$, impl.getCategories.bind(impl), false);
        this.helper_internal_.registerHandler(6, PageHandler_GetFeaturedGifs_ParamsSpec.$, PageHandler_GetFeaturedGifs_ResponseParamsSpec.$, impl.getFeaturedGifs.bind(impl), false);
        this.helper_internal_.registerHandler(7, PageHandler_SearchGifs_ParamsSpec.$, PageHandler_SearchGifs_ResponseParamsSpec.$, impl.searchGifs.bind(impl), false);
        this.helper_internal_.registerHandler(8, PageHandler_GetGifsByIds_ParamsSpec.$, PageHandler_GetGifsByIds_ResponseParamsSpec.$, impl.getGifsByIds.bind(impl), false);
        this.helper_internal_.registerHandler(9, PageHandler_OnUiFullyLoaded_ParamsSpec.$, null, impl.onUiFullyLoaded.bind(impl), false);
        this.helper_internal_.registerHandler(10, PageHandler_GetInitialCategory_ParamsSpec.$, PageHandler_GetInitialCategory_ResponseParamsSpec.$, impl.getInitialCategory.bind(impl), false);
        this.helper_internal_.registerHandler(11, PageHandler_GetInitialQuery_ParamsSpec.$, PageHandler_GetInitialQuery_ResponseParamsSpec.$, impl.getInitialQuery.bind(impl), false);
        this.helper_internal_.registerHandler(12, PageHandler_UpdateHistoryInPrefs_ParamsSpec.$, null, impl.updateHistoryInPrefs.bind(impl), false);
        this.helper_internal_.registerHandler(13, PageHandler_UpdatePreferredVariantsInPrefs_ParamsSpec.$, null, impl.updatePreferredVariantsInPrefs.bind(impl), false);
        this.helper_internal_.registerHandler(14, PageHandler_GetHistoryFromPrefs_ParamsSpec.$, PageHandler_GetHistoryFromPrefs_ResponseParamsSpec.$, impl.getHistoryFromPrefs.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "emoji_picker.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.showUI =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_ShowUI_ParamsSpec.$, null, this.showUI.createReceiverHandler(false /* expectsResponse */), false);
        this.insertEmoji =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_InsertEmoji_ParamsSpec.$, null, this.insertEmoji.createReceiverHandler(false /* expectsResponse */), false);
        this.insertGif =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_InsertGif_ParamsSpec.$, null, this.insertGif.createReceiverHandler(false /* expectsResponse */), false);
        this.isIncognitoTextField =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_IsIncognitoTextField_ParamsSpec.$, PageHandler_IsIncognitoTextField_ResponseParamsSpec.$, this.isIncognitoTextField.createReceiverHandler(true /* expectsResponse */), false);
        this.getFeatureList =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_GetFeatureList_ParamsSpec.$, PageHandler_GetFeatureList_ResponseParamsSpec.$, this.getFeatureList.createReceiverHandler(true /* expectsResponse */), false);
        this.getCategories =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_GetCategories_ParamsSpec.$, PageHandler_GetCategories_ResponseParamsSpec.$, this.getCategories.createReceiverHandler(true /* expectsResponse */), false);
        this.getFeaturedGifs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PageHandler_GetFeaturedGifs_ParamsSpec.$, PageHandler_GetFeaturedGifs_ResponseParamsSpec.$, this.getFeaturedGifs.createReceiverHandler(true /* expectsResponse */), false);
        this.searchGifs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, PageHandler_SearchGifs_ParamsSpec.$, PageHandler_SearchGifs_ResponseParamsSpec.$, this.searchGifs.createReceiverHandler(true /* expectsResponse */), false);
        this.getGifsByIds =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, PageHandler_GetGifsByIds_ParamsSpec.$, PageHandler_GetGifsByIds_ResponseParamsSpec.$, this.getGifsByIds.createReceiverHandler(true /* expectsResponse */), false);
        this.onUiFullyLoaded =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, PageHandler_OnUiFullyLoaded_ParamsSpec.$, null, this.onUiFullyLoaded.createReceiverHandler(false /* expectsResponse */), false);
        this.getInitialCategory =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, PageHandler_GetInitialCategory_ParamsSpec.$, PageHandler_GetInitialCategory_ResponseParamsSpec.$, this.getInitialCategory.createReceiverHandler(true /* expectsResponse */), false);
        this.getInitialQuery =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, PageHandler_GetInitialQuery_ParamsSpec.$, PageHandler_GetInitialQuery_ResponseParamsSpec.$, this.getInitialQuery.createReceiverHandler(true /* expectsResponse */), false);
        this.updateHistoryInPrefs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, PageHandler_UpdateHistoryInPrefs_ParamsSpec.$, null, this.updateHistoryInPrefs.createReceiverHandler(false /* expectsResponse */), false);
        this.updatePreferredVariantsInPrefs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, PageHandler_UpdatePreferredVariantsInPrefs_ParamsSpec.$, null, this.updatePreferredVariantsInPrefs.createReceiverHandler(false /* expectsResponse */), false);
        this.getHistoryFromPrefs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, PageHandler_GetHistoryFromPrefs_ParamsSpec.$, PageHandler_GetHistoryFromPrefs_ResponseParamsSpec.$, this.getHistoryFromPrefs.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const EmojiVariantSpec = { $: {} };
export const HistoryItemSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_ShowUI_ParamsSpec = { $: {} };
export const PageHandler_InsertEmoji_ParamsSpec = { $: {} };
export const PageHandler_InsertGif_ParamsSpec = { $: {} };
export const PageHandler_IsIncognitoTextField_ParamsSpec = { $: {} };
export const PageHandler_IsIncognitoTextField_ResponseParamsSpec = { $: {} };
export const PageHandler_GetFeatureList_ParamsSpec = { $: {} };
export const PageHandler_GetFeatureList_ResponseParamsSpec = { $: {} };
export const PageHandler_GetCategories_ParamsSpec = { $: {} };
export const PageHandler_GetCategories_ResponseParamsSpec = { $: {} };
export const PageHandler_GetFeaturedGifs_ParamsSpec = { $: {} };
export const PageHandler_GetFeaturedGifs_ResponseParamsSpec = { $: {} };
export const PageHandler_SearchGifs_ParamsSpec = { $: {} };
export const PageHandler_SearchGifs_ResponseParamsSpec = { $: {} };
export const PageHandler_GetGifsByIds_ParamsSpec = { $: {} };
export const PageHandler_GetGifsByIds_ResponseParamsSpec = { $: {} };
export const PageHandler_OnUiFullyLoaded_ParamsSpec = { $: {} };
export const PageHandler_GetInitialCategory_ParamsSpec = { $: {} };
export const PageHandler_GetInitialCategory_ResponseParamsSpec = { $: {} };
export const PageHandler_GetInitialQuery_ParamsSpec = { $: {} };
export const PageHandler_GetInitialQuery_ResponseParamsSpec = { $: {} };
export const PageHandler_UpdateHistoryInPrefs_ParamsSpec = { $: {} };
export const PageHandler_UpdatePreferredVariantsInPrefs_ParamsSpec = { $: {} };
export const PageHandler_GetHistoryFromPrefs_ParamsSpec = { $: {} };
export const PageHandler_GetHistoryFromPrefs_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(EmojiVariantSpec.$, 'EmojiVariant', [
    mojo.internal.StructField('base', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('variant', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(HistoryItemSpec.$, 'HistoryItem', [
    mojo.internal.StructField('emoji', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('timestamp', 8, 0, mojoBase_mojom_JSTimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('handler', 0, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ShowUI_ParamsSpec.$, 'PageHandler_ShowUI_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_InsertEmoji_ParamsSpec.$, 'PageHandler_InsertEmoji_Params', [
    mojo.internal.StructField('emoji', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isVariant', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('searchLength', 10, 0, mojo.internal.Int16, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_InsertGif_ParamsSpec.$, 'PageHandler_InsertGif_Params', [
    mojo.internal.StructField('gif', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_IsIncognitoTextField_ParamsSpec.$, 'PageHandler_IsIncognitoTextField_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_IsIncognitoTextField_ResponseParamsSpec.$, 'PageHandler_IsIncognitoTextField_ResponseParams', [
    mojo.internal.StructField('incognito', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetFeatureList_ParamsSpec.$, 'PageHandler_GetFeatureList_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetFeatureList_ResponseParamsSpec.$, 'PageHandler_GetFeatureList_ResponseParams', [
    mojo.internal.StructField('featureList', 0, 0, mojo.internal.Array(FeatureSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetCategories_ParamsSpec.$, 'PageHandler_GetCategories_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetCategories_ResponseParamsSpec.$, 'PageHandler_GetCategories_ResponseParams', [
    mojo.internal.StructField('status', 0, 0, tenor_mojom_StatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('gifCategories', 8, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetFeaturedGifs_ParamsSpec.$, 'PageHandler_GetFeaturedGifs_Params', [
    mojo.internal.StructField('pos', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetFeaturedGifs_ResponseParamsSpec.$, 'PageHandler_GetFeaturedGifs_ResponseParams', [
    mojo.internal.StructField('status', 0, 0, tenor_mojom_StatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('featuredGifs', 8, 0, tenor_mojom_PaginatedGifResponsesSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_SearchGifs_ParamsSpec.$, 'PageHandler_SearchGifs_Params', [
    mojo.internal.StructField('query', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pos', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_SearchGifs_ResponseParamsSpec.$, 'PageHandler_SearchGifs_ResponseParams', [
    mojo.internal.StructField('status', 0, 0, tenor_mojom_StatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('searchGifs', 8, 0, tenor_mojom_PaginatedGifResponsesSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetGifsByIds_ParamsSpec.$, 'PageHandler_GetGifsByIds_Params', [
    mojo.internal.StructField('ids', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetGifsByIds_ResponseParamsSpec.$, 'PageHandler_GetGifsByIds_ResponseParams', [
    mojo.internal.StructField('status', 0, 0, tenor_mojom_StatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('selectedGifs', 8, 0, mojo.internal.Array(tenor_mojom_GifResponseSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_OnUiFullyLoaded_ParamsSpec.$, 'PageHandler_OnUiFullyLoaded_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetInitialCategory_ParamsSpec.$, 'PageHandler_GetInitialCategory_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetInitialCategory_ResponseParamsSpec.$, 'PageHandler_GetInitialCategory_ResponseParams', [
    mojo.internal.StructField('category', 0, 0, CategorySpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetInitialQuery_ParamsSpec.$, 'PageHandler_GetInitialQuery_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetInitialQuery_ResponseParamsSpec.$, 'PageHandler_GetInitialQuery_ResponseParams', [
    mojo.internal.StructField('query', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_UpdateHistoryInPrefs_ParamsSpec.$, 'PageHandler_UpdateHistoryInPrefs_Params', [
    mojo.internal.StructField('category', 0, 0, CategorySpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('history', 8, 0, mojo.internal.Array(HistoryItemSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_UpdatePreferredVariantsInPrefs_ParamsSpec.$, 'PageHandler_UpdatePreferredVariantsInPrefs_Params', [
    mojo.internal.StructField('preferredVariants', 0, 0, mojo.internal.Array(EmojiVariantSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetHistoryFromPrefs_ParamsSpec.$, 'PageHandler_GetHistoryFromPrefs_Params', [
    mojo.internal.StructField('category', 0, 0, CategorySpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetHistoryFromPrefs_ResponseParamsSpec.$, 'PageHandler_GetHistoryFromPrefs_ResponseParams', [
    mojo.internal.StructField('history', 0, 0, mojo.internal.Array(HistoryItemSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
