// chromeos/ash/components/emoji/emoji_search.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export class EmojiSearchPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'emoji_search.mojom.EmojiSearch', scope);
    }
}
export class EmojiSearchRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(EmojiSearchPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    searchEmoji(query, languageCodes) {
        return this.proxy.sendMessage(0, EmojiSearch_SearchEmoji_ParamsSpec.$, EmojiSearch_SearchEmoji_ResponseParamsSpec.$, [
            query,
            languageCodes
        ], false);
    }
    loadEmojiLanguages(languageCodes) {
        this.proxy.sendMessage(1, EmojiSearch_LoadEmojiLanguages_ParamsSpec.$, null, [
            languageCodes
        ], false);
    }
}
;
/**
 * An object which receives request messages for the EmojiSearch
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class EmojiSearchReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(EmojiSearchRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, EmojiSearch_SearchEmoji_ParamsSpec.$, EmojiSearch_SearchEmoji_ResponseParamsSpec.$, impl.searchEmoji.bind(impl), false);
        this.helper_internal_.registerHandler(1, EmojiSearch_LoadEmojiLanguages_ParamsSpec.$, null, impl.loadEmojiLanguages.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class EmojiSearch {
    static get $interfaceName() {
        return "emoji_search.mojom.EmojiSearch";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new EmojiSearchRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the EmojiSearch
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class EmojiSearchCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(EmojiSearchRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.searchEmoji =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, EmojiSearch_SearchEmoji_ParamsSpec.$, EmojiSearch_SearchEmoji_ResponseParamsSpec.$, this.searchEmoji.createReceiverHandler(true /* expectsResponse */), false);
        this.loadEmojiLanguages =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, EmojiSearch_LoadEmojiLanguages_ParamsSpec.$, null, this.loadEmojiLanguages.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const SearchResultsSpec = { $: {} };
export const EmojiSearch_SearchEmoji_ParamsSpec = { $: {} };
export const EmojiSearch_SearchEmoji_ResponseParamsSpec = { $: {} };
export const EmojiSearch_LoadEmojiLanguages_ParamsSpec = { $: {} };
mojo.internal.Struct(SearchResultsSpec.$, 'SearchResults', [
    mojo.internal.StructField('results', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(EmojiSearch_SearchEmoji_ParamsSpec.$, 'EmojiSearch_SearchEmoji_Params', [
    mojo.internal.StructField('query', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('languageCodes', 8, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(EmojiSearch_SearchEmoji_ResponseParamsSpec.$, 'EmojiSearch_SearchEmoji_ResponseParams', [
    mojo.internal.StructField('emojiResults', 0, 0, SearchResultsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('symbolResults', 8, 0, SearchResultsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('emoticonResults', 16, 0, SearchResultsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(EmojiSearch_LoadEmojiLanguages_ParamsSpec.$, 'EmojiSearch_LoadEmojiLanguages_Params', [
    mojo.internal.StructField('languageCodes', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
