// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_toggle/cr_toggle.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{EnterpriseReportingBrowserProxy}from"./browser_proxy.js";import{getTemplate}from"./reporting_history.html.js";export class ReportingHistoryElement extends PolymerElement{constructor(){super(...arguments);this.browserProxy=EnterpriseReportingBrowserProxy.getInstance();this.filterOptions=[ReportingHistoryElement.allEvents,ReportingHistoryElement.allButUploads,"QueueAction","Enqueue","Flush","Confirm","Upload","BlockedRecord","BlockedDestinations"];this.selectedOption=ReportingHistoryElement.allEvents}static get is(){return"reporting-history-element"}static get template(){return getTemplate()}static get properties(){return{loggingState:Boolean,filterOptions:{type:Array,value:()=>[]},selectedOption:{type:String,value:""}}}static{this.allEvents="All events"}static{this.allButUploads="All events except uploads"}loggingStateToString(checked){return checked?"On":"Off"}onToggleChange(event){event.stopPropagation();this.browserProxy.handler.recordDebugState(event.detail)}onFilterChange(){const currentSelection=this.$.erpTableFilter.value;if(this.selectedOption!==currentSelection){this.selectedOption=currentSelection;this.updateErpTable()}}onDownloadButtonClick(){const tableRows=this.$.body.querySelectorAll(".erp-history-table tr");const csv=[];tableRows.forEach((currentRow=>{const row=[];const cols=currentRow.querySelectorAll("td, th");cols.forEach((currentCol=>{let value="";if(currentCol.className==="erp-parameters"){currentCol.querySelectorAll("li").forEach((el=>{value+=el.innerText+" - "}))}else{value=currentCol.innerHTML}row.push(value)}));csv.push(row.join(","))}));const csvFile=new Blob([csv.join("\n")],{type:"text/csv"});const url=URL.createObjectURL(csvFile);const a=document.createElement("a");a.href=url;a.download=`reporting_logs_${(new Date).toISOString()}.csv`;a.click();a.remove();URL.revokeObjectURL(url)}connectedCallback(){super.connectedCallback();this.setEmptyErpTable();this.browserProxy.callbackRouter.setErpHistoryData.addListener((historyData=>{this.currentHistory=historyData;this.updateErpTable()}))}ready(){super.ready();this.browserProxy.handler.getDebugState().then((({state:state})=>{this.loggingState=state}));this.browserProxy.handler.getErpHistoryData().then((({historyData:historyData})=>{this.currentHistory=historyData;this.updateErpTable()}))}setEmptyErpTable(){const emptyRow=document.createElement("tr");emptyRow.replaceChildren(this.createHistoryTableDataCell("No events","erp-type"),this.composeEventParameters([],"erp-parameters"),this.createHistoryTableDataCell("","erp-status"),this.createHistoryTableDataCell("","erp-timestamp"));this.$.body.appendChild(emptyRow)}updateErpTable(){this.$.body.replaceChildren();if(this.currentHistory.events.length===0){this.setEmptyErpTable();return}const filteredEvents=this.currentHistory.events.filter((event=>event.call===this.selectedOption||this.selectedOption===ReportingHistoryElement.allEvents||this.selectedOption===ReportingHistoryElement.allButUploads&&event.call!=="Upload"));if(filteredEvents.length===0){this.setEmptyErpTable();return}for(const event of filteredEvents.reverse()){const row=this.composeTableRow(event);this.$.body.appendChild(row)}}composeTableRow(event){const row=document.createElement("tr");row.replaceChildren(this.createHistoryTableDataCell(this.erpHistoryTypeToString(event.call),"erp-type"),this.composeEventParameters(event.parameters,"erp-parameters"),this.createHistoryTableDataCell(event.status,"erp-status"),this.createHistoryTableDataCell(this.timestampToString(Number(event.time)),"erp-timestamp"));return row}composeEventParameters(parameters,className){const list=document.createElement("ul");for(const parameter of parameters){const line=document.createElement("li");line.textContent=parameter.name+": "+parameter.value;list.appendChild(line)}const element=document.createElement("td");element.appendChild(list);element.classList.add(className);return element}createHistoryTableDataCell(textContent,className){const td=document.createElement("td");td.classList.add(className);td.textContent=textContent;return td}erpHistoryTypeToString(erpHistoryType){return erpHistoryType||"Unknown"}timestampToString(timestampSeconds){if(timestampSeconds===0){return"N/A"}assert(!Number.isNaN(timestampSeconds));const timestamp=new Date(timestampSeconds*1e3);const now=new Date;if(timestamp.getDate()===now.getDate()){return timestamp.toLocaleTimeString()}return timestamp.toLocaleString()}}customElements.define(ReportingHistoryElement.is,ReportingHistoryElement);