import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style>.controls{display:flex;flex-wrap:nowrap;font-family:monospace;font-weight:bold;gap:10px;padding:20px;align-items:center}.prefix{font-weight:bold;padding-inline-end:5px}.download-button,.select-filter{height:30px;margin-bottom:5px;width:150px}.erp-type{min-width:100px}.erp-parameters{min-width:660px}.erp-status{min-width:80px}.erp-timestamp{min-width:100px}.erp-span{min-width:10px}.erp-history-table{width:100%;font-family:monospace}.erp-history-table tbody{display:block;max-height:500px;overflow-y:scroll}.erp-history-table th{text-align:start}.erp-history-table td{text-align:start;vertical-align:top}.erp-history-table ul{list-style:none;margin-block:0px;padding-inline-start:0px;padding-top:0px}.erp-history-table li{padding-inline-start:0px;text-align:start}.erp-history-table thead,.erp-history-table tbody tr{display:table;width:100%}.erp-history-table tbody tr:nth-child(odd){background-color:lightgrey}.erp-history-table tbody::-webkit-scrollbar{width:10px;background-color:lightblue}.erp-history-table tbody::-webkit-scrollbar-thumb{background:darkblue;border-radius:5px}</style>

<div class="controls">
  <span class="prefix">History: [[loggingStateToString(loggingState)]]</span>
  <cr-toggle checked="{{loggingState}}" on-change="onToggleChange"></cr-toggle>
  <span class="prefix"> Filter by: </span>
  <select id="erpTableFilter" class="select-filter" value="[[selectedOption]]" on-change="onFilterChange">
    <template is="dom-repeat" items="[[filterOptions]]">
      <option value="[[item]]">[[item]]</option>
    </template>
  </select>
  <button class="download-button" on-click="onDownloadButtonClick">Download as CSV</button>
</div>
<table class="erp-history-table">
  <thead>
    <tr>
      <th class="erp-type">Type</th>
      <th class="erp-parameters">Parameters</th>
      <th class="erp-status">Status</th>
      <th class="erp-timestamp">Timestamp</th>
      <th class="erp-span"></th>
    </tr>
  </thead>
  <tbody class="erp-history-body" id="body">
  </tbody>
</table>
<!--_html_template_end_-->`;
}
