// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import"//resources/polymer/v3_0/paper-progress/paper-progress.js";import"/components/oobe_cr_lottie.js";import"/components/oobe_icons.html.js";import"/components/oobe_illo_icons.html.js";import"/components/oobe_network_icons.html.js";import"/components/common_styles/oobe_dialog_host_styles.css.js";import"/components/dialogs/oobe_adaptive_dialog.js";import"/components/buttons/oobe_text_button.js";import"chrome://resources/ash/common/network/network_select.js";import{NetworkList}from"//resources/ash/common/network/network_list_types.js";import{$}from"//resources/ash/common/util.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeCrLottie}from"/components/oobe_cr_lottie.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{OncMojo}from"chrome://resources/ash/common/network/onc_mojo.js";import{CrosNetworkConfig,StartConnectResult}from"chrome://resources/mojo/chromeos/services/network_config/public/mojom/cros_network_config.mojom-webui.js";import{getTemplate}from"./app.html.js";const EXPECTED_LOAD_TIME_MILLISEC=1e4;const FloatingWorkspaceBase=I18nMixin(PolymerElement);export class FloatingWorkspace extends FloatingWorkspaceBase{static get is(){return"floating-workspace"}static get template(){return getTemplate()}constructor(){super();this.networkConfig=CrosNetworkConfig.getRemote();this.defaultDialogTitleString=this.i18n("floatingWorkspaceStartupDialogTitle")}ready(){super.ready();window.addEventListener("orientationchange",(()=>{this.onWindowResolutionChange_()}));window.addEventListener("resize",(()=>{this.onWindowResolutionChange_()}));this.onWindowResolutionChange_();chrome.send("initialize")}showDefaultScreen(){this.hideAllScreens();this.$.defaultDialog.hidden=false;this.defaultDialogTitleString=this.i18n("floatingWorkspaceStartupDialogTitle");setTimeout(this.onNoResponse.bind(this),EXPECTED_LOAD_TIME_MILLISEC);this.$.defaultDialog.onBeforeShow();this.$.defaultDialog.show();this.playAnimation()}showNetworkScreen(){this.hideAllScreens();this.$.networkErrorDialog.hidden=false;this.$.networkErrorDialog.onBeforeShow();this.$.networkErrorDialog.show()}showErrorScreen(){this.hideAllScreens();this.$.generalErrorDialog.hidden=false;this.$.generalErrorDialog.onBeforeShow();this.$.generalErrorDialog.show()}hideAllScreens(){this.$.networkErrorDialog.hidden=true;this.$.defaultDialog.hidden=true;this.$.generalErrorDialog.hidden=true}onWindowResolutionChange_(){if(!document.documentElement.hasAttribute("screen")){document.documentElement.style.setProperty("--oobe-oobe-dialog-height-base",window.innerHeight+"px");document.documentElement.style.setProperty("--oobe-oobe-dialog-width-base",window.innerWidth+"px");if(window.innerWidth>window.innerHeight){document.documentElement.setAttribute("orientation","horizontal")}else{document.documentElement.setAttribute("orientation","vertical")}}}getNetworkCustomItems(){return[{customItemType:NetworkList.CustomItemType.OOBE,customItemName:"addWiFiListItemName",polymerIcon:"oobe-network-20:add-wifi",showBeforeNetworksList:false}]}onNetworkItemSelected(event){const networkState=event.detail;if(OncMojo.connectionStateIsConnected(networkState.connectionState)){chrome.send("showNetworkDetails",[networkState.guid]);return}if(networkState.connectable===false||networkState.errorState){chrome.send("showNetworkConfig",[networkState.guid]);return}this.networkConfig.startConnect(networkState.guid).then((response=>{if(response.result===StartConnectResult.kSuccess){return}chrome.send("showNetworkConfig",[networkState.guid])}))}onCustomItemSelected(event){chrome.send("addNetwork",[event.detail.customData])}onNoResponse(){this.defaultDialogTitleString=this.i18n("floatingWorkspaceStartupDialogLongResponseTitle")}onCancelButtonClick_(){chrome.send("dialogClose",["stopRestoringSession"])}playAnimation(){const animation=this.shadowRoot?.querySelector("#checkingAnimation");if(animation instanceof OobeCrLottie){animation.playing=true}}}function initialize(){window.$=$}customElements.define(FloatingWorkspace.is,FloatingWorkspace);initialize();