// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import{html,PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{Authenticator}from"../gaia_auth_host/authenticator.js";import{getTemplate}from"./gaia_action_buttons.html.js";let ActionButtonsData;const authenticatorEventListeners=[{event:"setPrimaryActionLabel",field:"primaryActionButtonLabel"},{event:"setPrimaryActionEnabled",field:"primaryActionButtonEnabled"},{event:"setSecondaryActionLabel",field:"secondaryActionButtonLabel"},{event:"setSecondaryActionEnabled",field:"secondaryActionButtonEnabled"}];export class GaiaActionButtonsElement extends PolymerElement{static get is(){return"gaia-action-buttons"}static get template(){return getTemplate()}static get properties(){return{authenticator:{type:Object,observer:"authenticatorChanged_"},roundedButton:{type:Boolean,value:false},actionButtonClasses_:{type:String,computed:"getActionButtonClasses_(roundedButton)"},secondaryButtonClasses_:{type:String,computed:"getSecondaryButtonClasses_(roundedButton)"},data_:{type:Object,value(){return{primaryActionButtonLabel:"",primaryActionButtonEnabled:true,secondaryActionButtonLabel:"",secondaryActionButtonEnabled:true}}}}}authenticatorChanged_(){if(this.authenticator){this.addAuthenticatorListeners_()}}addAuthenticatorListeners_(){authenticatorEventListeners.forEach((listenParams=>{this.authenticator.addEventListener(listenParams.event,(e=>{this.set(`data_.${listenParams.field}`,e.detail)}))}));this.authenticator.addEventListener("setAllActionsEnabled",(e=>this.onSetAllActionsEnabled_(e)))}onSetAllActionsEnabled_(e){this.set("data_.primaryActionButtonEnabled",e.detail);this.set("data_.secondaryActionButtonEnabled",e.detail)}onPrimaryActionButtonClicked_(){this.authenticator.sendMessageToWebview("primaryActionHit");this.focusWebview_()}onSecondaryActionButtonClicked_(){this.authenticator.sendMessageToWebview("secondaryActionHit");this.focusWebview_()}focusWebview_(){this.dispatchEvent(new CustomEvent("set-focus-to-webview",{bubbles:true,composed:true}))}getActionButtonClasses_(roundedButton){const cssClasses=["action-button"];if(roundedButton){cssClasses.push("rounded-button")}return cssClasses.join(" ")}getSecondaryButtonClasses_(roundedButton){const cssClasses=["secondary-button"];if(roundedButton){cssClasses.push("rounded-button")}return cssClasses.join(" ")}setAuthenticatorForTest(authenticator){this.authenticator=authenticator;this.addAuthenticatorListeners_()}}customElements.define(GaiaActionButtonsElement.is,GaiaActionButtonsElement);