// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cr_button/cr_button.js";import"//resources/ash/common/cr_elements/cr_menu_selector/cr_menu_selector.js";import"//resources/ash/common/cr_elements/cr_nav_menu_item_style.css.js";import"//resources/ash/common/cr_elements/cr_shared_style.css.js";import"//resources/ash/common/cr_elements/md_select.css.js";import"//resources/polymer/v3_0/iron-location/iron-location.js";import"//resources/polymer/v3_0/iron-pages/iron-pages.js";import"./healthd_internals_shared.css.js";import"./view/pages/info.js";import"./view/pages/system_trend.js";import"./view/pages/process.js";import"./view/pages/telemetry.js";import"./view/settings/settings_dialog.js";import{sendWithPromise}from"//resources/js/cr.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./app.html.js";import{DataManager}from"./model/data_manager.js";export var PagePath;(function(PagePath){PagePath["NONE"]="/";PagePath["INFO"]="/info";PagePath["TELEMETRY"]="/telemetry";PagePath["PROCESS"]="/process";PagePath["SYSTEM_TREND"]="/system_trend"})(PagePath||(PagePath={}));export class HealthdInternalsAppElement extends PolymerElement{constructor(){super(...arguments);this.pageList=[];this.currentPath=PagePath.NONE;this.selectedIndex=-1}static get is(){return"healthd-internals-app"}static get template(){return getTemplate()}static get properties(){return{pageList:{type:Array},currentPath:{type:String,observer:"currentPathChanged"},selectedIndex:{type:Number,observer:"selectedIndexChanged"}}}connectedCallback(){super.connectedCallback();this.dataManager=new DataManager(this.$.settingsDialog.getDataRetentionDuration(),this.$.infoPage,this.$.telemetryPage,this.$.systemTrendPage.getController());this.$.settingsDialog.addEventListener("ui-update-interval-updated",(()=>{this.updateUiUpdateInterval()}));this.$.settingsDialog.addEventListener("polling-cycle-updated",(()=>{this.setupFetchDataRequests()}));this.$.settingsDialog.addEventListener("data-retention-updated",(()=>{this.updateDataRetentionDuration()}));sendWithPromise("getHealthdInternalsFeatureFlag").then((data=>{if(!data.tabsDisplayed){this.currentPath=PagePath.NONE;return}this.pageList=[{name:"Info",path:PagePath.INFO,obj:this.$.infoPage},{name:"Telemetry",path:PagePath.TELEMETRY,obj:this.$.telemetryPage},{name:"Process Viewer",path:PagePath.PROCESS,obj:this.$.processPage},{name:"System Trend",path:PagePath.SYSTEM_TREND,obj:this.$.systemTrendPage}];this.updateSelectedIndex(this.currentPath);this.updateUiUpdateInterval();this.setupFetchDataRequests();this.updateDataRetentionDuration()}))}areTabsHidden(){return!this.pageList.length}currentPathChanged(newValue){if(this.areTabsHidden()){return}this.updateSelectedIndex(newValue)}selectedIndexChanged(newIndex,oldIndex){if(this.areTabsHidden()){return}if(newIndex>=0&&newIndex<this.pageList.length){this.currentPath=this.pageList[newIndex].path}this.handleVisibilityChanged(newIndex,true);this.handleVisibilityChanged(oldIndex,false)}updateSelectedIndex(newPath){const pageIndex=Math.max(0,this.pageList.findIndex((page=>page.path===newPath)));this.selectedIndex=pageIndex}handleVisibilityChanged(pageIndex,isVisible){if(pageIndex>=0&&pageIndex<this.pageList.length){this.pageList[pageIndex].obj.updateVisibility(isVisible)}}updateUiUpdateInterval(){const interval=this.$.settingsDialog.getUiUpdateInterval();for(const page of this.pageList){page.obj.updateUiUpdateInterval(interval)}}setupFetchDataRequests(){if(this.areTabsHidden()){console.warn("Data fetching requests are ignored when tabs are not displayed.");return}this.dataManager.setupFetchDataRequests(this.$.settingsDialog.getHealthdDataPollingCycle())}openSettingsDialog(){this.$.settingsDialog.openSettingsDialog()}updateDataRetentionDuration(){if(!this.pageList.length){console.warn("Data retention duration is ignored when tabs are not displayed.");return}const duration=this.$.settingsDialog.getDataRetentionDuration();this.dataManager.updateDataRetentionDuration(duration)}toggleSidebar(){this.$.sidebar.classList.toggle("collapsed");this.$.sidebarToggleButton.innerText=this.$.sidebar.classList.contains("collapsed")?">":"<"}}customElements.define(HealthdInternalsAppElement.is,HealthdInternalsAppElement);