// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{BACKGROUND_COLOR,GRID_COLOR,MIN_LABEL_HORIZONTAL_SPACING,MIN_LABEL_VERTICAL_SPACING,MIN_TIME_LABEL_HORIZONTAL_SPACING,TEXT_COLOR,TEXT_SIZE,TIME_STEP_UNITS,Y_AXIS_TICK_LENGTH}from"../utils/line_chart_configs.js";function getMinimumTimeStep(minSpacing,timeScale){const timeStepUnits=TIME_STEP_UNITS;let timeStep=0;for(let i=0;i<timeStepUnits.length;++i){if(timeStepUnits[i]/timeScale>=minSpacing){timeStep=timeStepUnits[i];break}}return timeStep}export class CanvasDrawer{constructor(){this.graphWidth=1;this.graphHeight=1;this.footerHeight=TEXT_SIZE+MIN_LABEL_VERTICAL_SPACING}initCanvas(context,canvasWidth,canvasHeight){this.initAndClearContext(context,canvasWidth,canvasHeight);this.graphWidth=canvasWidth;this.graphHeight=canvasHeight-this.footerHeight;this.renderChartGrid(context)}getUnitLabelHeight(){return this.graphHeight-2}initAndClearContext(context,canvasWidth,canvasHeight){context.font=`${TEXT_SIZE}px Arial`;context.lineWidth=2;context.lineCap="round";context.lineJoin="round";context.fillStyle=BACKGROUND_COLOR;context.fillRect(0,0,canvasWidth,canvasHeight)}renderChartGrid(context){context.strokeStyle=GRID_COLOR;context.strokeRect(0,0,this.graphWidth-1,this.graphHeight)}renderTimeLabels(context,startTime,timeScale){const sampleText=new Date(startTime).toLocaleTimeString();const minSpacing=context.measureText(sampleText).width+MIN_TIME_LABEL_HORIZONTAL_SPACING;const timeStep=getMinimumTimeStep(minSpacing,timeScale);if(timeStep===0){console.warn("Render time label failed. Cannot find minimum time unit.");return}context.textBaseline="bottom";context.textAlign="center";context.fillStyle=TEXT_COLOR;context.strokeStyle=GRID_COLOR;context.beginPath();const yCoord=this.graphHeight+this.footerHeight;const firstTimeTick=Math.ceil(startTime/timeStep)*timeStep;let time=firstTimeTick;while(true){const xCoord=Math.round((time-startTime)/timeScale);if(xCoord>=this.graphWidth){break}const text=new Date(time).toLocaleTimeString();context.fillText(text,xCoord,yCoord);context.moveTo(xCoord,0);context.lineTo(xCoord,this.graphHeight-1);time+=timeStep}context.stroke()}renderLine(context,dataPoints,displayedColor,startTime,timeScale,valueScale){if(dataPoints.length===0){return}context.strokeStyle=displayedColor;context.fillStyle=displayedColor;context.beginPath();for(const point of dataPoints){const xCoord=Math.round((point.time-startTime)/timeScale);const chartYCoord=Math.round(point.value/valueScale);const realYCoord=this.graphHeight-1-chartYCoord;context.lineTo(xCoord,realYCoord)}context.stroke();const firstXCoord=Math.round((dataPoints[0].time-startTime)/timeScale);const lastXCoord=Math.round((dataPoints[dataPoints.length-1].time-startTime)/timeScale);this.fillAreaBelowLine(context,firstXCoord,lastXCoord)}fillAreaBelowLine(context,firstXCoord,lastXCoord){context.lineTo(lastXCoord,this.graphHeight);context.lineTo(firstXCoord,this.graphHeight);context.globalAlpha=.05;context.fill();context.globalAlpha=1}renderUnitLabel(context,labelTexts){if(labelTexts.length===0){return}context.textAlign="right";const tickStartX=this.graphWidth-1;const tickEndX=this.graphWidth-1-Y_AXIS_TICK_LENGTH;const textXCoord=this.graphWidth-MIN_LABEL_HORIZONTAL_SPACING;const labelYStep=this.graphHeight/(labelTexts.length-1);this.renderLabelTicks(context,labelTexts,labelYStep,tickStartX,tickEndX);this.renderLabelTexts(context,labelTexts,labelYStep,textXCoord)}renderLabelTicks(context,labelTexts,labelYStep,tickStartX,tickEndX){context.strokeStyle=GRID_COLOR;context.beginPath();for(let i=1;i<labelTexts.length-1;++i){const yCoord=labelYStep*i;context.moveTo(tickStartX,yCoord);context.lineTo(tickEndX,yCoord)}context.stroke()}renderLabelTexts(context,labelTexts,labelYStep,textXCoord){context.fillStyle=TEXT_COLOR;context.textBaseline="top";context.fillText(labelTexts[0],textXCoord,0);context.textBaseline="bottom";for(let i=1;i<labelTexts.length;++i){const yCoord=labelYStep*i;context.fillText(labelTexts[i],textXCoord,yCoord)}}}