// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";import{LINE_CHART_COLOR_SET,MIN_TIME_SCALE,SAMPLE_RATE}from"../utils/line_chart_configs.js";import{CanvasDrawer}from"./canvas_drawer.js";import{CategoryTypeEnum}from"./system_trend_controller.js";import{UnitLabel}from"./unit_label.js";export function getLineChartColor(index){const colorIdx=index%LINE_CHART_COLOR_SET.length;return LINE_CHART_COLOR_SET[colorIdx]}function getStepSize(timeScale){const baseStepSize=MIN_TIME_SCALE*SAMPLE_RATE;const minStepSize=timeScale*SAMPLE_RATE;const minExponent=Math.log(minStepSize/baseStepSize)/Math.LN2;return baseStepSize*Math.pow(2,Math.ceil(minExponent))}export class LineChartController{constructor(element){this.canvasDrawer=new CanvasDrawer;this.chartUpdateTimer=0;this.startTime=Date.now();this.endTime=this.startTime;this.displayedDataSeriesLists=[];this.fixedMaxValue=null;this.element=element}setupDataSeries(category,dataSeriesLists){this.displayedCategory=category;this.displayedDataSeriesLists=dataSeriesLists;if(this.displayedCategory===CategoryTypeEnum.CPU_USAGE){this.fixedMaxValue=100}else{this.fixedMaxValue=null}}updateDataTime(){let newStartTime=Number.MAX_SAFE_INTEGER;for(const data of this.displayedDataSeriesLists){for(const dataSeries of data.dataList){const points=dataSeries.getPoints();const length=points.length;if(length!==0){newStartTime=Math.min(newStartTime,points[0].time);this.endTime=Math.max(this.endTime,points[length-1].time)}}}if(newStartTime!==Number.MAX_SAFE_INTEGER){this.startTime=Math.max(this.startTime,newStartTime)}}getScrollableRange(canvasWidth,timeScale){return Math.max(this.getChartWidth(timeScale)-canvasWidth,0)}getChartWidth(timeScale){const timeRange=this.endTime-this.startTime;return Math.floor(timeRange/timeScale)}updateCanvas(context,canvasWidth,canvasHeight,timeScale,scrollbarPosition){clearTimeout(this.chartUpdateTimer);this.chartUpdateTimer=setTimeout((()=>this.renderCanvas(context,canvasWidth,canvasHeight,timeScale,scrollbarPosition)))}renderCanvas(context,canvasWidth,canvasHeight,timeScale,scrollbarPosition){this.canvasDrawer.initCanvas(context,canvasWidth,canvasHeight);if(this.displayedDataSeriesLists.length===0){console.warn("LineChartController: Empty data.");return}if(this.getScrollableRange(canvasWidth,timeScale)===0){scrollbarPosition=this.getChartWidth(timeScale)-canvasWidth}const visibleStartTime=this.startTime+scrollbarPosition*timeScale;const visibleEndTime=visibleStartTime+canvasWidth*timeScale;this.canvasDrawer.renderTimeLabels(context,visibleStartTime,timeScale);const stepSize=getStepSize(timeScale);if(this.displayedDataSeriesLists.length===1){this.renderSingleDataSource(context,visibleStartTime,visibleEndTime,stepSize,timeScale)}else{this.renderMultipleDataSource(context,visibleStartTime,visibleEndTime,stepSize,timeScale)}this.updateSummaryTable(visibleStartTime,visibleEndTime,stepSize)}renderSingleDataSource(context,visibleStartTime,visibleEndTime,stepSize,timeScale){assert(this.displayedDataSeriesLists.length===1);const dataSeriesList=this.displayedDataSeriesLists[0].dataList;const unitLabel=this.displayedDataSeriesLists[0].unitLabel;const maxValue=this.getVisibleMaxValue(dataSeriesList,visibleStartTime,visibleEndTime,stepSize);unitLabel.setMaxValue(maxValue);unitLabel.setLayout(this.canvasDrawer.getUnitLabelHeight());this.canvasDrawer.renderUnitLabel(context,unitLabel.getLabels());for(const[index,dataSeries]of dataSeriesList.entries()){const dataPoints=dataSeries.getDisplayedPoints(visibleStartTime,visibleEndTime,stepSize);this.canvasDrawer.renderLine(context,dataPoints,getLineChartColor(index),visibleStartTime,timeScale,unitLabel.getValueScale())}}renderMultipleDataSource(context,visibleStartTime,visibleEndTime,stepSize,timeScale){assert(this.displayedDataSeriesLists.length>=1);const normalizedUpperBound=1;const pixelScale=normalizedUpperBound/this.canvasDrawer.getUnitLabelHeight();const sharedUnitLabel=new UnitLabel([""],1);sharedUnitLabel.setMaxValue(normalizedUpperBound);sharedUnitLabel.setLayout(this.canvasDrawer.getUnitLabelHeight());this.canvasDrawer.renderUnitLabel(context,sharedUnitLabel.getLabels());let colorIndex=0;for(const data of this.displayedDataSeriesLists){const maxValue=this.getVisibleMaxValue(data.dataList,visibleStartTime,visibleEndTime,stepSize);data.unitLabel.setMaxValue(maxValue);data.unitLabel.setLayout(this.canvasDrawer.getUnitLabelHeight());const valueScale=this.getNormalizationScale(maxValue)*pixelScale;for(const dataSeries of data.dataList){const dataPoints=dataSeries.getDisplayedPoints(visibleStartTime,visibleEndTime,stepSize);this.canvasDrawer.renderLine(context,dataPoints,getLineChartColor(colorIndex),visibleStartTime,timeScale,valueScale);colorIndex+=1}}}getVisibleMaxValue(dataSeriesList,visibleStartTime,visibleEndTime,stepSize){if(this.fixedMaxValue!=null){return this.fixedMaxValue}return dataSeriesList.reduce(((maxValue,item)=>Math.max(maxValue,item.getDisplayedMaxValue(visibleStartTime,visibleEndTime,stepSize))),0)}getNormalizationScale(maxValue){return Math.pow(2,Math.ceil(Math.log(maxValue)/Math.log(2)))}updateSummaryTable(visibleStartTime,visibleEndTime,stepSize){const output=[];let colorIndex=0;for(const data of this.displayedDataSeriesLists){const unitScale=data.unitLabel.getUnitScale();const unitString=data.unitLabel.getUnitString();for(const dataSeries of data.dataList){const statistics=dataSeries.getLatestStatistics(visibleStartTime,visibleEndTime);const info={legendColor:getLineChartColor(colorIndex),name:dataSeries.getTitle(),isVisible:dataSeries.getVisible(),displayedUnit:unitString,latestValue:statistics.latest/unitScale,minValue:statistics.min/unitScale,maxValue:statistics.max/unitScale,averageValue:statistics.average/unitScale};if(this.displayedCategory===CategoryTypeEnum.CUSTOM){info.name=dataSeries.getTitleForCustom();const maxValue=this.getVisibleMaxValue(data.dataList,visibleStartTime,visibleEndTime,stepSize);const normalizationScale=this.getNormalizationScale(maxValue);info.normalizationWeight=unitScale/normalizationScale;info.normalizedValue=statistics.latest/normalizationScale}output.push(info);colorIndex+=1}}this.element.getSummaryTable().updateSummaryInfo(output);this.element.updateVisibleTimeSpan(visibleStartTime,visibleEndTime)}}