// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{MAX_LABEL_VERTICAL_NUM,MIN_LABEL_VERTICAL_SPACING,TEXT_SIZE}from"../utils/line_chart_configs.js";export class UnitLabel{constructor(units,unitBase){this.maxValue=0;this.maxValueCache=0;this.currentUnitIdx=0;this.labels=[];this.height=0;this.precision=2;this.valueScale=1;this.isCache=false;this.units=units;if(units.length===0){console.error("UnitLabel: Length of units must greater than 0.")}this.unitBase=unitBase;if(unitBase<=0){console.error("UnitLabel: unitBase must greater than 0.")}}getLabels(){this.updateLabelsAndScale();return this.labels}getValueScale(){this.updateLabelsAndScale();return this.valueScale}getUnitScale(){return Math.pow(this.unitBase,this.currentUnitIdx)}getUnitString(){return this.units[this.currentUnitIdx]}setLayout(height){if(this.height===height){return}this.height=height;this.isCache=false}setMaxValue(maxValue){if(this.maxValueCache===maxValue){return}this.maxValueCache=maxValue;const result=this.getSuitableUnit(maxValue);this.currentUnitIdx=result.unitIdx;this.maxValue=result.value;this.isCache=false}getSuitableUnit(value){let unitIdx=0;while(unitIdx+1<this.units.length&&value>=this.unitBase){value/=this.unitBase;++unitIdx}return{unitIdx:unitIdx,value:value}}updateLabelsAndScale(){if(this.isCache){return}this.isCache=true;if(this.maxValue===0){return}const result=this.getSuitableStepSize();const stepSize=result.stepSize;const stepSizePrecision=result.stepSizePrecision;const topLabelValue=this.getTopLabelValue(this.maxValue,stepSize);const unitStr=this.getUnitString();const labels=[];for(let value=topLabelValue;value>=0;value-=stepSize){const valueStr=value.toFixed(stepSizePrecision);const label=valueStr+" "+unitStr;labels.push(label)}this.labels=labels;const realTopValue=this.getRealValueWithCurrentUnit(topLabelValue);this.valueScale=realTopValue/this.height}getTopLabelValue(maxValue,stepSize){return Math.ceil(maxValue/stepSize)*stepSize}getRealValueWithCurrentUnit(value){return value*this.getUnitScale()}getSuitableStepSize(){const maxLabelNum=this.getMaxNumberOfLabel();let stepSize=Math.pow(10,-this.precision);let stepSizePrecision=Math.max(this.precision,0);while(true){if(this.getNumberOfLabelWithStepSize(stepSize)<=maxLabelNum){break}if(this.getNumberOfLabelWithStepSize(stepSize*2)<=maxLabelNum){stepSize*=2;break}if(this.getNumberOfLabelWithStepSize(stepSize*5)<=maxLabelNum){stepSize*=5;break}stepSize*=10;if(stepSizePrecision>0){--stepSizePrecision}}return{stepSize:stepSize,stepSizePrecision:stepSizePrecision}}getMaxNumberOfLabel(){const minLabelSpacing=2*TEXT_SIZE+MIN_LABEL_VERTICAL_SPACING;const maxLabelNum=1+Math.floor(this.height/minLabelSpacing);return Math.min(Math.max(maxLabelNum,2),MAX_LABEL_VERTICAL_NUM)}getNumberOfLabelWithStepSize(stepSize){return Math.ceil(this.maxValue/stepSize)+1}}