// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";function getAveragePoint(points){const valueSum=points.reduce(((acc,item)=>acc+item.value),0);const timeSum=points.reduce(((acc,item)=>acc+item.time),0);return{value:valueSum/points.length,time:timeSum/points.length}}export class DataSeries{constructor(title,category){this.dataPoints=[];this.isVisible=true;this.cachedStartTime=0;this.cachedEndTime=0;this.cachedStepSize=0;this.displayedPoints=[];this.maxValue=0;this.displayedTitle=title;this.displayedCategory=category}addDataPoint(value,time){if(!isFinite(value)||!isFinite(time)){console.warn("Add invalid data to DataSeries: value: "+value+", time: "+time);return}const length=this.dataPoints.length;if(length>0&&this.dataPoints[length-1].time>time){console.warn("Add invalid time to DataSeries: "+time+". Time must be non-strictly increasing.");return}this.dataPoints.push({value:value,time:time})}setVisible(isVisible){this.isVisible=isVisible}getVisible(){return this.isVisible}getTitle(){return this.displayedTitle}getTitleForCustom(){return`${this.displayedTitle} (${this.displayedCategory})`}getPoints(){return this.dataPoints}getDisplayedPoints(startTime,endTime,stepSize){if(!this.isVisible){return[]}this.updateCachedData(startTime,endTime,stepSize);return this.displayedPoints}getDisplayedMaxValue(startTime,endTime,stepSize){if(!this.isVisible){return 0}this.updateCachedData(startTime,endTime,stepSize);return this.maxValue}updateCachedData(startTime,endTime,stepSize){if(this.cachedStartTime===startTime&&this.cachedEndTime===endTime&&this.cachedStepSize===stepSize){return}this.displayedPoints=this.getDisplayedPointsInner(startTime,endTime,stepSize);this.maxValue=this.displayedPoints.reduce(((maxValue,item)=>Math.max(maxValue,item.value)),0);this.cachedStartTime=startTime;this.cachedEndTime=endTime;this.cachedStepSize=stepSize}getDisplayedPointsInner(startTime,endTime,stepSize){const output=[];let pointsInStep=[];const storeDisplayedPoint=()=>{if(pointsInStep.length!==0){output.push(getAveragePoint(pointsInStep));pointsInStep=[]}};let currentStepStart=startTime-startTime%stepSize-stepSize;let currentIndex=this.findLowerBoundPointIndex(currentStepStart);if(currentIndex>=this.dataPoints.length){return[]}if(this.dataPoints[currentIndex].time>startTime&&currentIndex>=1){output.push(this.dataPoints[currentIndex-1])}while(currentIndex<this.dataPoints.length){if(output.length!==0&&output[output.length-1].time>=endTime){break}const currentPoint=this.dataPoints[currentIndex];assert(currentPoint.time>=currentStepStart);const currentStepEnd=currentStepStart+stepSize;if(currentPoint.time>=currentStepEnd){storeDisplayedPoint();currentStepStart=currentStepEnd}else{pointsInStep.push(currentPoint);currentIndex+=1}}storeDisplayedPoint();return output}findLowerBoundPointIndex(time){let lower=0;let upper=this.dataPoints.length;while(lower<upper){const mid=Math.floor((lower+upper)/2);const point=this.dataPoints[mid];if(time<=point.time){upper=mid}else{lower=mid+1}}return lower}removeOutdatedData(startTime){const dataRetentionBuffer=1*60*60*1e3;const bufferStartIndex=this.findLowerBoundPointIndex(startTime-dataRetentionBuffer);if(bufferStartIndex>0){const newStartIndex=this.findLowerBoundPointIndex(startTime);assert(newStartIndex>=bufferStartIndex);this.dataPoints.splice(0,newStartIndex)}}getLatestStatistics(startTime,endTime){const output={latest:0,min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY,average:0};let count=0;const lowerBound=this.findLowerBoundPointIndex(startTime);for(let i=lowerBound;i<this.dataPoints.length;++i){if(this.dataPoints[i].time>endTime){break}output.latest=this.dataPoints[i].value;output.min=Math.min(this.dataPoints[i].value,output.min);output.max=Math.max(this.dataPoints[i].value,output.max);output.average+=this.dataPoints[i].value;count+=1}if(count!==0){output.average/=count}return output}}