// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./info_card.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getFormattedMemory,getFormattedMemoryFromRaw,getFormattedMemoryWithPercentage,MemoryUnitEnum}from"../../utils/memory_utils.js";import{toFixedFloat}from"../../utils/number_utils.js";import{getTemplate}from"./memory_card.html.js";export class HealthdInternalsMemoryCardElement extends PolymerElement{constructor(){super(...arguments);this.memoryUnit=MemoryUnitEnum.AUTO}static get is(){return"healthd-internals-memory-card"}static get template(){return getTemplate()}static get properties(){return{memoryUnit:{type:String}}}connectedCallback(){super.connectedCallback();this.$.infoCard.appendCardRow("INFO",true);this.$.infoCard.appendCardRow("SWAP",true);this.$.infoCard.appendCardRow("ZRAM",true);this.$.infoCard.appendCardRow("DETAILS")}updateTelemetryData(data){this.latestMemoryInfo=data.memory;this.refreshMemoryCard()}updateZramData(zram){this.latestZramInfo=zram;this.refreshMemoryCard()}updateExpanded(isExpanded){this.$.infoCard.updateExpanded(isExpanded)}refreshMemoryCard(){if(this.latestMemoryInfo!==undefined){const memory=this.latestMemoryInfo;this.updateInfoRow(parseInt(memory.totalMemoryKib),parseInt(memory.freeMemoryKib),parseInt(memory.availableMemoryKib));if(memory.totalSwapMemoryKib!==undefined&&memory.freeSwapMemoryKib!==undefined){this.updateSwapRow(parseInt(memory.totalSwapMemoryKib),parseInt(memory.freeSwapMemoryKib))}this.updateDetailsRow(memory)}if(this.latestZramInfo!==undefined){this.updateZramRow(this.latestZramInfo)}}updateInfoRow(totalMemoryKib,freeMemoryKib,availableMemoryKib){const usedMemoryKib=totalMemoryKib-availableMemoryKib;const unit=this.memoryUnit;this.$.infoCard.updateDisplayedInfo(0,{Total:getFormattedMemory(unit,totalMemoryKib),Used:getFormattedMemoryWithPercentage(unit,usedMemoryKib,totalMemoryKib),Avail:getFormattedMemoryWithPercentage(unit,availableMemoryKib,totalMemoryKib),Free:getFormattedMemoryWithPercentage(unit,freeMemoryKib,totalMemoryKib)})}updateSwapRow(totalSwapMemoryKib,freeSwapMemoryKib){const usedSwapMemoryKib=totalSwapMemoryKib-freeSwapMemoryKib;const unit=this.memoryUnit;this.$.infoCard.updateDisplayedInfo(1,{Total:getFormattedMemory(unit,totalSwapMemoryKib),Used:getFormattedMemoryWithPercentage(unit,usedSwapMemoryKib,totalSwapMemoryKib),Free:getFormattedMemoryWithPercentage(unit,freeSwapMemoryKib,totalSwapMemoryKib)})}updateZramRow(zram){const totalUsedMemoryKib=parseInt(zram.totalUsedMemory)/1024;const originalDataSizeKib=parseInt(zram.originalDataSize)/1024;const compressedDataSizeKib=parseInt(zram.compressedDataSize)/1024;const compressionRatio=originalDataSizeKib/compressedDataSizeKib;const spaceReductionPercentage=(originalDataSizeKib-compressedDataSizeKib)/originalDataSizeKib*100;const unit=this.memoryUnit;this.$.infoCard.updateDisplayedInfo(2,{"Total Used":getFormattedMemory(unit,totalUsedMemoryKib),"Original Size":getFormattedMemory(unit,originalDataSizeKib),"Compressed Size":getFormattedMemory(unit,compressedDataSizeKib),"Compression Ratio":toFixedFloat(compressionRatio,2),"Space Reduction":`${toFixedFloat(spaceReductionPercentage,2)}%`})}updateDetailsRow(memory){const unit=this.memoryUnit;this.$.infoCard.updateDisplayedInfo(3,{Buffers:getFormattedMemoryFromRaw(unit,memory.buffersKib),"Page Cache":getFormattedMemoryFromRaw(unit,memory.pageCacheKib),Shared:getFormattedMemoryFromRaw(unit,memory.sharedMemoryKib),Active:getFormattedMemoryFromRaw(unit,memory.activeMemoryKib),Inactive:getFormattedMemoryFromRaw(unit,memory.inactiveMemoryKib),"Total Slab":getFormattedMemoryFromRaw(unit,memory.totalSlabMemoryKib),"Reclaimable Slab":getFormattedMemoryFromRaw(unit,memory.reclaimableSlabMemoryKib),"Unreclaimable Slab":getFormattedMemoryFromRaw(unit,memory.unreclaimableSlabMemoryKib),"Cached Swap":getFormattedMemoryFromRaw(unit,memory.cachedSwapMemoryKib)})}onMemoryUnitChanged(){this.memoryUnit=this.$.memoryUnitSelector.value;this.refreshMemoryCard()}}customElements.define(HealthdInternalsMemoryCardElement.is,HealthdInternalsMemoryCardElement);