// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./menu.js";import"./scrollbar.js";import"./chart_summary_table.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{LineChartController}from"../../controller/line_chart_controller.js";import{CategoryTypeEnum}from"../../controller/system_trend_controller.js";import{DEFAULT_TIME_SCALE,DRAG_RATE,MAX_TIME_SCALE,MIN_TIME_SCALE,MOUSE_WHEEL_SCROLL_RATE,MOUSE_WHEEL_UNITS,TOUCH_ZOOM_UNITS,ZOOM_RATE}from"../../utils/line_chart_configs.js";import{getTemplate}from"./line_chart.html.js";function getTouchsDistance(touchA,touchB){const diffX=touchA.clientX-touchB.clientX;const diffY=touchA.clientY-touchB.clientY;return Math.sqrt(diffX*diffX+diffY*diffY)}export class HealthdInternalsLineChartElement extends PolymerElement{constructor(){super(...arguments);this.controller=new LineChartController(this);this.timeScale=DEFAULT_TIME_SCALE;this.isDragging=false;this.dragX=0;this.isTouching=false;this.touchX=0;this.touchZoomBase=0;this.isVisible=false;this.visibleStartTime=0;this.visibleEndTime=0}static get is(){return"healthd-internals-line-chart"}static get template(){return getTemplate()}connectedCallback(){super.connectedCallback();this.initCanvasEventHandlers();const resizeObserver=new ResizeObserver((()=>{this.resizeCanvas();this.updateCanvas()}));resizeObserver.observe(this.$.chartRoot);window.addEventListener("bar-scroll",(()=>{this.updateCanvas()}));window.addEventListener("menu-buttons-updated",(()=>{this.updateCanvas()}))}getController(){return this.controller}getSummaryTable(){return this.$.summaryTable}setupDataSeries(category,dataSeriesLists){this.controller.setupDataSeries(category,dataSeriesLists);const flatDataList=dataSeriesLists.reduce(((acc,val)=>acc.concat(val.dataList)),[]);const isCustomCategory=category===CategoryTypeEnum.CUSTOM;this.$.chartMenu.setupDataSeries(flatDataList,isCustomCategory);this.$.summaryTable.setIsCustomCategory(isCustomCategory);this.resizeCanvas()}refreshLineChart(){this.controller.updateDataTime();this.updateScrollBar();this.updateCanvas()}updateVisibility(isVisible){this.isVisible=isVisible;if(isVisible){this.refreshLineChart()}}toggleChartSummaryTable(isVisible){this.$.chartContainer.style.setProperty("--summary-table-height",isVisible?"200px":"0px")}updateVisibleTimeSpan(visibleStartTime,visibleEndTime){this.visibleStartTime=visibleStartTime;this.visibleEndTime=visibleEndTime;this.dispatchEvent(new CustomEvent("time-range-changed",{bubbles:true,composed:true}))}getVisibleTimeSpan(){return[this.visibleStartTime,this.visibleEndTime]}initCanvasEventHandlers(){const canvas=this.$.mainCanvas;canvas.addEventListener("wheel",(e=>this.onWheel(e)));canvas.addEventListener("mousedown",(e=>this.onMouseDown(e)));canvas.addEventListener("mousemove",(e=>this.onMouseMove(e)));canvas.addEventListener("mouseup",(e=>this.onMouseUpOrOut(e)));canvas.addEventListener("mouseout",(e=>this.onMouseUpOrOut(e)));canvas.addEventListener("touchstart",(e=>this.onTouchStart(e)));canvas.addEventListener("touchmove",(e=>this.onTouchMove(e)));canvas.addEventListener("touchend",(e=>this.onTouchEnd(e)));canvas.addEventListener("touchcancel",(e=>this.onTouchCancel(e)))}onWheel(event){event.preventDefault();const wheelEvent=event;const wheelX=wheelEvent.deltaX/MOUSE_WHEEL_UNITS;const wheelY=-wheelEvent.deltaY/MOUSE_WHEEL_UNITS;this.scrollChart(MOUSE_WHEEL_SCROLL_RATE*wheelX);this.zoomChart(Math.pow(ZOOM_RATE,-wheelY))}onMouseDown(event){event.preventDefault();this.isDragging=true;this.dragX=event.clientX}onMouseMove(event){event.preventDefault();if(!this.isDragging){return}const mouseEvent=event;const dragDeltaX=mouseEvent.clientX-this.dragX;this.scrollChart(DRAG_RATE*dragDeltaX);this.dragX=mouseEvent.clientX}onMouseUpOrOut(event){event.preventDefault();this.isDragging=false}onTouchStart(event){event.preventDefault();this.isTouching=true;const touches=event.targetTouches;if(touches.length===1){this.touchX=touches[0].clientX}else if(touches.length===2){this.touchZoomBase=getTouchsDistance(touches[0],touches[1])}}onTouchMove(event){event.preventDefault();if(!this.isTouching){return}const touches=event.targetTouches;if(touches.length===1){const dragDeltaX=this.touchX-touches[0].clientX;this.scrollChart(DRAG_RATE*dragDeltaX);this.touchX=touches[0].clientX}else if(touches.length===2){const newDistance=getTouchsDistance(touches[0],touches[1]);const zoomDelta=(this.touchZoomBase-newDistance)/TOUCH_ZOOM_UNITS;this.zoomChart(Math.pow(ZOOM_RATE,zoomDelta));this.touchZoomBase=newDistance}}onTouchEnd(event){event.preventDefault();this.isTouching=false}onTouchCancel(event){event.preventDefault();this.isTouching=false}zoomChart(rate){const oldScale=this.timeScale;const newScale=this.timeScale*rate;this.timeScale=Math.max(MIN_TIME_SCALE,Math.min(newScale,MAX_TIME_SCALE));if(this.timeScale===oldScale){return}this.updateScrollBar();if(this.$.chartScrollbar.isScrolledToRightEdge()){this.$.chartScrollbar.scrollToRightEdge()}else{const oldPosition=this.$.chartScrollbar.getPosition();const canvasWidth=this.$.mainCanvas.width;const visibleEndTime=oldScale*(oldPosition+canvasWidth);const newPosition=Math.round(visibleEndTime/this.timeScale)-canvasWidth;this.$.chartScrollbar.setPosition(newPosition)}this.updateCanvas()}scrollChart(delta){const oldPosition=this.$.chartScrollbar.getPosition();const newPosition=oldPosition+Math.round(delta);this.$.chartScrollbar.setPosition(newPosition);if(this.$.chartScrollbar.getPosition()===oldPosition){return}this.updateCanvas()}resizeCanvas(){const expectedWidth=this.$.chartRoot.offsetWidth-this.$.chartMenu.getWidth();const expectedHeight=this.$.chartRoot.offsetHeight-this.$.chartScrollbar.getHeight();if(this.$.mainCanvas.width===expectedWidth&&this.$.mainCanvas.height===expectedHeight){return}this.$.mainCanvas.width=expectedWidth;this.$.mainCanvas.height=expectedHeight;this.$.chartScrollbar.resize(expectedWidth);this.updateScrollBar()}updateScrollBar(){if(!this.isVisible){return}const scrollbar=this.$.chartScrollbar;const range=this.controller.getScrollableRange(this.$.mainCanvas.width,this.timeScale);scrollbar.setScrollableRange(range);const isScrolledToRightEdge=scrollbar.isScrolledToRightEdge();if(isScrolledToRightEdge&&!this.isDragging){scrollbar.scrollToRightEdge()}}updateCanvas(){const canvas=this.$.mainCanvas;const context=canvas.getContext("2d");if(context===null||!this.isVisible){return}this.controller.updateCanvas(context,canvas.width,canvas.height,this.timeScale,this.$.chartScrollbar.getPosition())}}customElements.define(HealthdInternalsLineChartElement.is,HealthdInternalsLineChartElement);