// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cr_button/cr_button.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getLineChartColor}from"../../controller/line_chart_controller.js";import{MENU_TEXT_COLOR_DARK,MENU_TEXT_COLOR_LIGHT}from"../../utils/line_chart_configs.js";import{getTemplate}from"./menu.html.js";function createElementWithClassName(type,className){const element=document.createElement(type);element.className=className;return element}export class HealthdInternalsLineChartMenuElement extends PolymerElement{constructor(){super(...arguments);this.isCustomCategory=false;this.buttons=[]}static get is(){return"healthd-internals-line-chart-menu"}static get template(){return getTemplate()}getWidth(){return this.$.dataButtonsContainer.offsetWidth}setupDataSeries(dataSeriesList,isCustomCategory){this.isCustomCategory=isCustomCategory;this.cleanUpButtons();for(const[index,dataSeries]of dataSeriesList.entries()){const color=getLineChartColor(index);const button=this.createButton(dataSeries,color);this.$.dataButtonsContainer.appendChild(button);this.buttons.push({data:dataSeries,color:color,element:button})}}cleanUpButtons(){const buttonContainer=this.$.dataButtonsContainer;while(buttonContainer.lastElementChild){buttonContainer.removeChild(buttonContainer.lastElementChild)}this.buttons=[]}fireMenuButtonsUpdatedEvent(){this.dispatchEvent(new CustomEvent("menu-buttons-updated",{bubbles:true,composed:true}))}createButton(dataSeries,color){const buttonInner=createElementWithClassName("span","line-chart-menu-button-inner-span");buttonInner.innerText=this.isCustomCategory?dataSeries.getTitleForCustom():dataSeries.getTitle();const button=createElementWithClassName("div","line-chart-menu-button");button.appendChild(buttonInner);this.setupButtonOnClickHandler(button,dataSeries,color);this.updateButtonStyle(button,dataSeries,color);return button}setupButtonOnClickHandler(button,dataSeries,color){button.addEventListener("click",(()=>{dataSeries.setVisible(!dataSeries.getVisible());this.updateButtonStyle(button,dataSeries,color);this.fireMenuButtonsUpdatedEvent()}))}updateButtonStyle(button,dataSeries,color){if(dataSeries.getVisible()){button.style.backgroundColor=color;button.style.color=MENU_TEXT_COLOR_LIGHT}else{button.style.backgroundColor=MENU_TEXT_COLOR_LIGHT;button.style.color=MENU_TEXT_COLOR_DARK}}onEnableAllButtonClick(){for(const button of this.buttons){button.data.setVisible(true);this.updateButtonStyle(button.element,button.data,button.color)}this.fireMenuButtonsUpdatedEvent()}onDisableAllButtonClicked(){for(const button of this.buttons){button.data.setVisible(false);this.updateButtonStyle(button.element,button.data,button.color)}this.fireMenuButtonsUpdatedEvent()}}customElements.define(HealthdInternalsLineChartMenuElement.is,HealthdInternalsLineChartMenuElement);