// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./scrollbar.html.js";export class HealthdInternalsLineChartScrollbarElement extends PolymerElement{constructor(){super(...arguments);this.scrollableRange=0;this.currentPosition=0;this.visibleWidth=0;this.atRightEdge=true}static get is(){return"healthd-internals-line-chart-scrollbar"}static get template(){return getTemplate()}connectedCallback(){super.connectedCallback();this.$.outerDiv.addEventListener("scroll",(()=>this.onScroll()))}getHeight(){return this.$.outerDiv.offsetHeight}getPosition(){return Math.round(this.currentPosition)}resize(width){if(this.visibleWidth===width){return}this.visibleWidth=width;this.$.outerDiv.style.width=this.visibleWidth+"px"}setScrollableRange(range){if(this.scrollableRange===range){return}this.scrollableRange=range;this.$.innerDiv.style.width=this.visibleWidth+this.scrollableRange+"px";if(this.scrollableRange<this.currentPosition){this.currentPosition=this.scrollableRange;this.updateScrollbarPosition()}}setPosition(position){const newPosition=Math.max(0,Math.min(position,this.scrollableRange));this.currentPosition=newPosition;this.updateScrollbarPosition()}isScrolledToRightEdge(){return this.atRightEdge}scrollToRightEdge(){this.setPosition(this.scrollableRange)}updateScrollbarPosition(){if(this.$.outerDiv.scrollLeft===this.currentPosition){return}this.$.outerDiv.scrollLeft=this.currentPosition}onScroll(){const newPosition=this.$.outerDiv.scrollLeft;if(newPosition===this.currentPosition){return}this.currentPosition=newPosition;const scrollLeftErrorAmount=2;this.atRightEdge=this.currentPosition+scrollLeftErrorAmount>this.scrollableRange;this.dispatchEvent(new CustomEvent("bar-scroll",{bubbles:true,composed:true}))}}customElements.define(HealthdInternalsLineChartScrollbarElement.is,HealthdInternalsLineChartScrollbarElement);