import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="healthd-internals-shared cr-shared-style md-select">#pageHeader{display:flex;height:60px;justify-content:space-between;align-items:center}#headerEndContainer{display:flex;padding-inline-end:32px;align-items:center}#settingsContainer{display:flex;height:60px;width:90%;overflow-x:auto;gap:48px;margin:0 32px;align-items:center}.setting-with-label-container{display:flex;align-items:center;gap:8px}cr-input{width:150px;--cr-input-error-display:none}#pageSizeSelector{width:70px}#sortColumnSelector{width:150px}#sortOrderSelector{width:100px}#tableContainer{height:calc(95vh - 60px - 60px);width:100%;overflow:auto}table{overflow:auto;border-collapse:collapse;margin:0 auto 16px auto}thead th{position:sticky;top:0;z-index:1;background-color:var(--cr-menu-background-color)}td{border-top:1px solid var(--scrollable-border-color)}th,td{color:var(--cr-primary-text-color);padding:8px 16px;text-align:center;max-width:100px;word-wrap:break-word}.command-column{text-align:left;max-width:600px}</style>


<div id="pageHeader">
  <h1>Processes</h1>
  <div id="headerEndContainer">
    <label>Last update: [[lastUpdateTime]]</label>
  </div>
</div>

<div id="settingsContainer">
  <div class="setting-with-label-container">
    <label>Filter</label>
    <cr-input type="text" value="{{filterQuery}}" placeholder="Enter query...">
    </cr-input>
  </div>
  <div class="setting-with-label-container">
    <label>Page Size</label>
    <select id="pageSizeSelector" class="md-select"
        on-change="onPageSizeChanged" value="[[pageSize]]">
      <option value=100>100</option>
      <option value=500>500</option>
      <option value=2000>2000</option>
    </select>
  </div>
  <div class="setting-with-label-container">
    <label>Sort column</label>
    <select id="sortColumnSelector" class="md-select"
        on-change="onSortColumnChanged" value="[[sortColumn]]">
      <template is="dom-repeat" items="[[displayedHeaders]]">
        <option value="[[item.sortColumnId]]">[[item.title]]</option>
      </template>
    </select>
  </div>
  <div class="setting-with-label-container">
    <label>Sort order</label>
    <select id="sortOrderSelector" class="md-select"
        on-change="onSortOrderChanged" value="[[sortOrder]]">
      <option value="ascend">Ascend</option>
      <option value="descend">Dscend</option>
    </select>
  </div>
</div>

<div id="tableContainer"><table>
  <thead>
    <tr>
      <template is="dom-repeat" items="[[displayedHeaders]]">
        <th>[[item.title]]</th>
      </template>
    </tr>
  </thead>
  <tbody>
    <template is="dom-repeat" items="[[displayedData]]">
      <tr>
        <td>[[item.processId]]</td>
        <td>[[item.name]]</td>
        <td>[[item.priority]]</td>
        <td>[[item.nice]]</td>
        <td>[[item.state]]</td>
        <td>[[item.threadsNumber]]</td>
        <td>[[item.userId]]</td>
        <td>[[item.parentProcessId]]</td>
        <td>[[item.processGroupId]]</td>
        <td>[[item.residentMemoryKib]]</td>
        <td>[[item.uptimeTicks]]</td>
        <td>[[item.readSystemCallsCount]]</td>
        <td>[[item.writeSystemCallsCount]]</td>
        <td class="command-column">[[item.command]]</td>
      </tr>
    </template>
  </tbody>
</table></div>
<!--_html_template_end_-->`}