// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cr_input/cr_input.js";import"//resources/ash/common/cr_elements/md_select.css.js";import{sendWithPromise}from"//resources/js/cr.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{UiUpdateHelper}from"../../utils/ui_update_helper.js";import{getTemplate}from"./process.html.js";var SortColumnEnum;(function(SortColumnEnum){SortColumnEnum["PROCESS_ID"]="processId";SortColumnEnum["NAME"]="name";SortColumnEnum["PRIORITY"]="priority";SortColumnEnum["NICE"]="nice";SortColumnEnum["STATE"]="state";SortColumnEnum["THREADS_NUMBER"]="threadsNumber";SortColumnEnum["USER_ID"]="userId";SortColumnEnum["PARENT_ID"]="parentProcessId";SortColumnEnum["GROUP_ID"]="processGroupId";SortColumnEnum["RESIDENT_MEMORY"]="residentMemoryKib";SortColumnEnum["UPTIME"]="uptimeTicks";SortColumnEnum["READ_SYSCALL_COUNT"]="readSystemCallsCount";SortColumnEnum["WRITE_SYSCALL_COUNT"]="writeSystemCallsCount";SortColumnEnum["COMMAND"]="command"})(SortColumnEnum||(SortColumnEnum={}));var SortOrderEnum;(function(SortOrderEnum){SortOrderEnum["ASCEND"]="ascend";SortOrderEnum["DESCEND"]="descend"})(SortOrderEnum||(SortOrderEnum={}));function filterProcessData(data,filterQuery){if(filterQuery===""){return data}return data.filter((process=>{const displayedName=process.name===undefined?"<unknown>":process.name;if(displayedName.includes(filterQuery)){return true}for(const stringField of[process.processId,process.state,process.threadsNumber,process.parentProcessId,process.processGroupId,process.readSystemCallsCount,process.writeSystemCallsCount,process.command]){if(stringField.includes(filterQuery)){return true}}for(const numberField of[process.nice,process.priority]){if(numberField.toString().includes(filterQuery)){return true}}return false}))}function convertProcessData(processes){return processes.map((item=>({processId:parseInt(item.processId),name:item.name===undefined?"<unknown>":item.name,priority:item.priority,nice:item.nice,state:item.state,threadsNumber:parseInt(item.threadsNumber),userId:parseInt(item.userId),parentProcessId:parseInt(item.parentProcessId),processGroupId:parseInt(item.processGroupId),residentMemoryKib:parseInt(item.residentMemoryKib),uptimeTicks:parseInt(item.uptimeTicks),readSystemCallsCount:parseInt(item.readSystemCallsCount),writeSystemCallsCount:parseInt(item.writeSystemCallsCount),command:item.command})))}function sortProcessData(processes,sortColumn,sortOrder){return processes.sort(((a,b)=>{if(a[sortColumn]===b[sortColumn]){return 0}if(sortOrder===SortOrderEnum.ASCEND){return a[sortColumn]<b[sortColumn]?-1:1}if(sortOrder===SortOrderEnum.DESCEND){return a[sortColumn]<b[sortColumn]?1:-1}console.error("Unknown sort order: ",sortOrder);return 0}))}export class HealthdInternalsProcessElement extends PolymerElement{constructor(){super(...arguments);this.displayedHeaders=[{title:"Process ID",sortColumnId:SortColumnEnum.PROCESS_ID},{title:"Name",sortColumnId:SortColumnEnum.NAME},{title:"Priority",sortColumnId:SortColumnEnum.PRIORITY},{title:"Nice",sortColumnId:SortColumnEnum.NICE},{title:"Process State",sortColumnId:SortColumnEnum.STATE},{title:"Threads Number",sortColumnId:SortColumnEnum.THREADS_NUMBER},{title:"User ID",sortColumnId:SortColumnEnum.USER_ID},{title:"Parent ID",sortColumnId:SortColumnEnum.PARENT_ID},{title:"Group ID",sortColumnId:SortColumnEnum.GROUP_ID},{title:"Resident Memory (KiB)",sortColumnId:SortColumnEnum.RESIDENT_MEMORY},{title:"Uptime Ticks",sortColumnId:SortColumnEnum.UPTIME},{title:"Count of read syscall",sortColumnId:SortColumnEnum.READ_SYSCALL_COUNT},{title:"Count of write syscall",sortColumnId:SortColumnEnum.WRITE_SYSCALL_COUNT},{title:"Command",sortColumnId:SortColumnEnum.COMMAND}];this.processData=[];this.filterQuery="";this.sortColumn=SortColumnEnum.PROCESS_ID;this.sortOrder=SortOrderEnum.ASCEND;this.pageSize=100;this.displayedData=[];this.lastUpdateTime=""}static get is(){return"healthd-internals-process"}static get template(){return getTemplate()}static get properties(){return{displayedHeaders:{type:Array},processData:{type:Array},filterQuery:{type:String},pageSize:{type:Number},sortColumn:{type:String},sortOrder:{type:String},displayedData:{type:Array,computed:"getDisplayedData(processData, "+"filterQuery, pageSize, sortColumn, sortOrder)"},lastUpdateTime:{type:String}}}connectedCallback(){super.connectedCallback();this.updateHelper=new UiUpdateHelper((()=>{sendWithPromise("getHealthdProcessInfo").then((data=>{this.processData=data.processes;this.lastUpdateTime=(new Date).toLocaleTimeString()}))}))}updateVisibility(isVisible){this.updateHelper.updateVisibility(isVisible)}updateUiUpdateInterval(intervalSeconds){this.updateHelper.updateUiUpdateInterval(intervalSeconds)}getDisplayedData(data,filterQuery,pageSize,sortColumn,sortOrder){return sortProcessData(convertProcessData(filterProcessData(data,filterQuery)),sortColumn,sortOrder).slice(0,pageSize)}onPageSizeChanged(){this.pageSize=parseInt(this.$.pageSizeSelector.value)}onSortColumnChanged(){this.sortColumn=this.$.sortColumnSelector.value}onSortOrderChanged(){this.sortOrder=this.$.sortOrderSelector.value}}customElements.define(HealthdInternalsProcessElement.is,HealthdInternalsProcessElement);