// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cr_button/cr_button.js";import"//resources/ash/common/cr_elements/md_select.css.js";import"../line_chart/line_chart.js";import"../settings/chart_category_dialog.js";import{assert}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{CategoryTypeEnum,SystemTrendController}from"../../controller/system_trend_controller.js";import{UiUpdateHelper}from"../../utils/ui_update_helper.js";import{getTemplate}from"./system_trend.html.js";function toReadableDuration(timeMilliseconds){if(timeMilliseconds<0){console.warn("Failed to get positive duration.");return"N/A"}const seconds=timeMilliseconds/1e3;const minutes=seconds/60;const hours=minutes/60;const formatTimeNumber=input=>Math.round(input).toString().padStart(2,"0");return`${formatTimeNumber(hours)}:${formatTimeNumber(minutes%60)}:${formatTimeNumber(seconds%60)}`}export class HealthdInternalsSystemTrendElement extends PolymerElement{constructor(){super(...arguments);this.controller=new SystemTrendController(this);this.isSummaryTableDisplayed=true;this.displayedCategories=[CategoryTypeEnum.CPU_USAGE,CategoryTypeEnum.CPU_FREQUENCY,CategoryTypeEnum.MEMORY,CategoryTypeEnum.ZRAM,CategoryTypeEnum.BATTERY,CategoryTypeEnum.THERMAL,CategoryTypeEnum.CUSTOM];this.selectedCategory=this.displayedCategories[0];this.displayedStartTime="";this.displayedEndTime="";this.displayedDuration=""}static get is(){return"healthd-internals-system-trend"}static get template(){return getTemplate()}static get properties(){return{isSummaryTableDisplayed:{type:Boolean},displayedCategories:{type:Array},selectedCategory:{type:String},displayedStartTime:{type:String},displayedEndTime:{type:String},displayedDuration:{type:String}}}connectedCallback(){super.connectedCallback();this.updateHelper=new UiUpdateHelper((()=>{this.$.lineChart.refreshLineChart()}));this.$.lineChart.addEventListener("time-range-changed",(()=>{this.updateDisplayedTimeInfo()}));this.$.categoryDialog.addEventListener("custom-data-updated",(()=>{assert(this.isCustomCategory(this.selectedCategory));this.refreshData(this.selectedCategory)}))}getController(){return this.controller}updateVisibility(isVisible){this.$.lineChart.updateVisibility(isVisible);this.updateHelper.updateVisibility(isVisible)}updateUiUpdateInterval(intervalSeconds){this.updateHelper.updateUiUpdateInterval(intervalSeconds)}refreshData(targetCategory){if(targetCategory!==this.selectedCategory){return}this.$.lineChart.setupDataSeries(targetCategory,this.controller.getData(targetCategory));this.$.lineChart.refreshLineChart()}updateDisplayedTimeInfo(){const[startTime,endTime]=this.$.lineChart.getVisibleTimeSpan();this.displayedStartTime=new Date(startTime).toLocaleTimeString();this.displayedEndTime=new Date(endTime).toLocaleTimeString();this.displayedDuration=toReadableDuration(endTime-startTime)}toggleChartSummaryTable(){this.isSummaryTableDisplayed=!this.isSummaryTableDisplayed;this.$.lineChart.toggleChartSummaryTable(this.isSummaryTableDisplayed)}onCategoryChanged(){this.selectedCategory=this.$.categorySelector.value;this.refreshData(this.selectedCategory)}openChartCategoryDialog(){assert(this.isCustomCategory(this.selectedCategory));this.$.categoryDialog.openDialog(this.getController())}isCustomCategory(category){return category===CategoryTypeEnum.CUSTOM}}customElements.define(HealthdInternalsSystemTrendElement.is,HealthdInternalsSystemTrendElement);