// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cr_button/cr_button.js";import"//resources/ash/common/cr_elements/cr_dialog/cr_dialog.js";import"./data_series_checkbox.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{CategoryTypeEnum}from"../../controller/system_trend_controller.js";import{getTemplate}from"./chart_category_dialog.html.js";export class HealthdInternalsChartCategoryDialogElement extends PolymerElement{constructor(){super(...arguments);this.controller=null}static get is(){return"healthd-internals-chart-category-dialog"}static get template(){return getTemplate()}openDialog(controller){this.controller=controller;this.$.batteryCheckbox.init("Battery",this.controller.getData(CategoryTypeEnum.BATTERY));this.$.cpuFrequencyCheckbox.init("CPU Frequency",this.controller.getData(CategoryTypeEnum.CPU_FREQUENCY));this.$.cpuUsageCheckbox.init("CPU Usage",this.controller.getData(CategoryTypeEnum.CPU_USAGE));this.$.memoryCheckbox.init("Memory",this.controller.getData(CategoryTypeEnum.MEMORY));this.$.thermalCheckbox.init("Thermal",this.controller.getData(CategoryTypeEnum.THERMAL));this.$.zramCheckbox.init("Zram",this.controller.getData(CategoryTypeEnum.ZRAM));this.$.dialog.showModal()}onConfirmButtonClicked(){this.controller?.setSelectedIndices(CategoryTypeEnum.BATTERY,this.$.batteryCheckbox.getSelectedIndices());this.controller?.setSelectedIndices(CategoryTypeEnum.CPU_FREQUENCY,this.$.cpuFrequencyCheckbox.getSelectedIndices());this.controller?.setSelectedIndices(CategoryTypeEnum.CPU_USAGE,this.$.cpuUsageCheckbox.getSelectedIndices());this.controller?.setSelectedIndices(CategoryTypeEnum.MEMORY,this.$.memoryCheckbox.getSelectedIndices());this.controller?.setSelectedIndices(CategoryTypeEnum.THERMAL,this.$.thermalCheckbox.getSelectedIndices());this.controller?.setSelectedIndices(CategoryTypeEnum.ZRAM,this.$.zramCheckbox.getSelectedIndices());this.dispatchEvent(new CustomEvent("custom-data-updated",{bubbles:true,composed:true}));this.controller=null;this.$.dialog.close()}onCancelButtonClicked(){this.controller=null;this.$.dialog.close()}}customElements.define(HealthdInternalsChartCategoryDialogElement.is,HealthdInternalsChartCategoryDialogElement);