// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cr_button/cr_button.js";import"//resources/ash/common/cr_elements/cr_dialog/cr_dialog.js";import"./config_slider.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./settings_dialog.html.js";export class HealthdInternalsSettingsDialogElement extends PolymerElement{constructor(){super(...arguments);this.uiUpdateInterval=2;this.dataPollingCycle=500;this.dataRetentionDuration=3}static get is(){return"healthd-internals-settings-dialog"}static get template(){return getTemplate()}static get properties(){return{uiUpdateInterval:{type:Number,observer:"onUiUpdateIntervalChanged"},dataPollingCycle:{type:Number,observer:"onDataPollingCycleChanged"},dataRetentionDuration:{type:Number,observer:"onDataRetentionDurationChanged"}}}connectedCallback(){super.connectedCallback();this.$.uiUpdateIntervalSlider.initSlider(1,5,1);this.$.uiUpdateIntervalSlider.initTitle("UI update interval (second)");this.$.dataPollingCycleSlider.initSlider(100,5e3,100);this.$.dataPollingCycleSlider.initTitle("Healthd data polling cycle (millisecond)");this.$.dataRetentionDurationSlider.initSlider(1,12,1);this.$.dataRetentionDurationSlider.initTitle("Data retention duration for line charts (hour)")}openSettingsDialog(){this.$.uiUpdateIntervalSlider.setTickValue(this.uiUpdateInterval);this.$.dataPollingCycleSlider.setTickValue(this.dataPollingCycle);this.$.dataRetentionDurationSlider.setTickValue(this.dataRetentionDuration);this.$.dialog.showModal()}getUiUpdateInterval(){return this.uiUpdateInterval}getHealthdDataPollingCycle(){return this.dataPollingCycle}getDataRetentionDuration(){return this.dataRetentionDuration}onCancelButtonClicked(){this.$.dialog.close()}onConfirmButtonClick(){this.uiUpdateInterval=this.$.uiUpdateIntervalSlider.getTickValue();this.dataPollingCycle=this.$.dataPollingCycleSlider.getTickValue();this.dataRetentionDuration=this.$.dataRetentionDurationSlider.getTickValue();this.$.dialog.close()}onUiUpdateIntervalChanged(){this.dispatchEvent(new CustomEvent("ui-update-interval-updated",{bubbles:true,composed:true}))}onDataPollingCycleChanged(){this.dispatchEvent(new CustomEvent("polling-cycle-updated",{bubbles:true,composed:true}))}onDataRetentionDurationChanged(){this.dispatchEvent(new CustomEvent("data-retention-updated",{bubbles:true,composed:true}))}}customElements.define(HealthdInternalsSettingsDialogElement.is,HealthdInternalsSettingsDialogElement);