import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="healthd-internals-shared cr-shared-style md-select">#tableContainer{height:100%;width:100%;overflow:auto;padding:0 16px}table{overflow:auto;margin:auto;width:90%;min-height:100%}thead th{position:sticky;top:0;z-index:1;background-color:var(--cr-menu-background-color)}th,td{color:var(--cr-primary-text-color);padding:6px;text-align:center;max-width:100px;word-wrap:break-word}td{border-top:1px solid var(--scrollable-border-color)}.legend-container{display:flex;align-items:center;justify-content:center;gap:16px}.square-legend{width:12px;height:12px}</style>

<div id="tableContainer">
  <table>
    <thead>
      <tr>
        <th></th>
        <th>Name</th>
        <th>Latest</th>
        <template is="dom-if" if="[[isCustomCategory]]">
          <th>Weight</th>
          <th>Normalized Value</th>
        </template>
        <th>Min.</th>
        <th>Max.</th>
        <th>Avg.</th>
      </tr>
    </thead>
    <tbody>
      <template is="dom-repeat" items="[[displayedData]]">
        <tr hidden="[[!item.isVisible]]">
          <td>
            <div class="legend-container">
              <div class="square-legend"
                   style$="background-color: [[item.legendColor]]"></div>
            </div>
          </td>
          <td>[[item.name]]</td>
          <td>[[item.latestValue]] [[item.displayedUnit]]</td>
          <template is="dom-if" if="[[isCustomCategory]]">
            <td>[[item.normalizationWeight]]</td>
            <td>[[item.normalizedValue]]</td>
          </template>
          <td>[[item.minValue]] [[item.displayedUnit]]</td>
          <td>[[item.maxValue]] [[item.displayedUnit]]</td>
          <td>[[item.averageValue]] [[item.displayedUnit]]</td>
        </tr>
      </template>
    </tbody>
  </table>
</div>
<!--_html_template_end_-->`;
}
