// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { toFixedFloat } from '../../utils/number_utils.js';
import { getTemplate } from './chart_summary_table.html.js';
export class HealthdInternalsChartSummaryTableElement extends PolymerElement {
    constructor() {
        super(...arguments);
        // Data displayed in the chart summary table.
        this.displayedData = [];
        // Whether the current category is custom.
        this.isCustomCategory = true;
    }
    static get is() {
        return 'healthd-internals-chart-summary-table';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            displayedData: { type: Array },
            isCustomCategory: { type: Boolean },
        };
    }
    /**
     * Sets whether the current category is custom.
     */
    setIsCustomCategory(isCustomCategory) {
        this.isCustomCategory = isCustomCategory;
    }
    /**
     * Update displayed data.
     */
    updateSummaryInfo(data) {
        this.displayedData = [];
        for (const info of data) {
            info.latestValue = parseFloat(toFixedFloat(info.latestValue, 3));
            info.minValue = parseFloat(toFixedFloat(info.minValue, 3));
            info.maxValue = parseFloat(toFixedFloat(info.maxValue, 3));
            info.averageValue = parseFloat(toFixedFloat(info.averageValue, 3));
            if (info.normalizationWeight !== undefined) {
                info.normalizationWeight =
                    parseFloat(toFixedFloat(info.normalizationWeight, 3));
            }
            if (info.normalizedValue !== undefined) {
                info.normalizedValue =
                    parseFloat(toFixedFloat(info.normalizedValue, 2));
            }
            this.displayedData.push(info);
        }
        // Create a copy to trigger a change for the new row in table.
        this.set('displayedData', this.displayedData.slice());
    }
}
customElements.define(HealthdInternalsChartSummaryTableElement.is, HealthdInternalsChartSummaryTableElement);
