// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/ash/common/cr_elements/cr_slider/cr_slider.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getTemplate } from './config_slider.html.js';
function createTicks(start, end, step) {
    const ticks = [];
    for (let tickValue = start; tickValue <= end; tickValue += step) {
        ticks.push({
            label: `${tickValue}`,
            value: tickValue,
        });
    }
    return ticks;
}
export class HealthdInternalsConfigSliderElement extends PolymerElement {
    constructor() {
        super(...arguments);
        // Set in `initTitle`.
        this.sliderTitle = '';
        // Set in `initSlider`.
        this.ticks = [];
        this.markerCounts = 0;
        this.startTick = 0;
        this.tickStepSize = 0;
        // Set in `setTickValue`.
        this.tickedIndex = 0;
    }
    static get is() {
        return 'healthd-internals-config-slider';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            sliderTitle: { type: String },
            ticks: { type: Array },
            markerCounts: { type: Number },
            tickedIndex: { type: Number },
        };
    }
    initTitle(title) {
        this.sliderTitle = title;
    }
    initSlider(start, end, stepSize) {
        this.ticks = createTicks(start, end, stepSize);
        // The width of slider is fixed to 200px. Hide tick markers when there are
        // too many. Otherwise, there is not enough space between tick markers.
        this.markerCounts = (this.ticks.length > 20) ? 0 : this.ticks.length;
        this.startTick = start;
        this.tickStepSize = stepSize;
    }
    setTickValue(actualValue) {
        this.tickedIndex = (actualValue - this.startTick) / this.tickStepSize;
    }
    getTickValue() {
        return this.ticks[this.tickedIndex].value;
    }
    onTickedValueChanged() {
        this.tickedIndex = this.$.tickSlider.value;
    }
}
customElements.define(HealthdInternalsConfigSliderElement.is, HealthdInternalsConfigSliderElement);
