import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-page-host-style cr-shared-style network-shared
    iron-flex cros-color-overrides">cr-dialog::part(dialog){border-radius:0;height:100%;width:100%}:host-context(body.jelly-enabled) cr-dialog::part(dialog){--cr-dialog-background-color:var(--cros-bg-color)}cr-dialog [slot=body]{height:480px}.error{color:var(--cros-text-color-alert);font-weight:500}</style>
<cr-dialog id="dialog" no-cancel>
  <div slot="title">[[getDialogTitle_(type_)]]</div>
  <div slot="body">
    <network-config id="networkConfig" class="flex"
        guid="[[guid_]]" type="{{type_}}"
        prefilled-properties="[[prefilledProperties_]]"
        enable-connect="{{enableConnect_}}"
        share-allow-enable="[[shareAllowEnable_]]"
        share-default="[[shareDefault_]]"
        error="{{error_}}"
        on-close="close_"
        connect-on-enter>
    </network-config>
  </div>
  <div class="layout horizontal center" slot="button-container">
    <template is="dom-if" if="[[shouldShowError_(firstConnect_, error_)]]"
        restamp>
      <div id="errorDiv" class="flex error">[[getError_(error_)]]</div>
    </template>
    <cr-button class="cancel-button" on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button" on-click="onConnectClick_"
        disabled="[[!enableConnect_]]">
      $i18n{networkButtonConnect}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
