import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-page-host-style cr-shared-style network-shared
    iron-flex cros-color-overrides">cr-policy-network-indicator-mojo{margin-inline-end:10px}.cr-row cr-button+cr-button{margin-inline-start:8px}.title{font-size:107.69%;font-weight:500;margin-inline-start:20px}#networkState[connected]{color:var(--cros-text-color-positive)}#networkState[warning]{color:var(--cros-text-color-warning)}.signin-button{margin-inline-end:8px;padding:8px 16px 8px 8px}.signin-icon{background-color:var(--text-color);margin-inline-end:4px;margin-inline-start:0}#apnRow{height:var(--cr-section-two-line-min-height)}#apnRowSublabel:not([warning]){color:var(--cros-text-color-positive)}.add-apn-operation{margin-bottom:10px;margin-inline-start:20px}.add-apn-operation iron-icon{--iron-icon-fill-color:var(--text-color);margin-inline-end:8px}.add-apn-operation[disabled] iron-icon{--iron-icon-fill-color:var(--disabled)}#apnTooltip{--paper-tooltip-background:var(--cros-tooltip-background-color);--paper-tooltip-text-color:var(--cros-tooltip-label-color);text-align:center}#apnButtonTitle{display:inline-block}</style>

<!-- Title section: Icon + name + connection state. -->
<div id="title" class="cr-row first">
  <network-icon
      show-technology-badge="[[showTechnologyBadge_]]"
      network-state="[[getNetworkState_(managedProperties_)]]">
  </network-icon>
  <div id="networkName" class="title">
    [[getNameText_(managedProperties_)]]
  </div>
  <div id="networkState" class="title flex"
      connected$="[[showConnectedState_(managedProperties_)]]"
      warning$="[[showRestrictedConnectivity_(managedProperties_)]]">
    [[getStateText_(managedProperties_)]]
  </div>
  <cr-button class="signin-button" id="signinButton" on-click="onSigninClicked_"
      hidden$="[[!showSignin_(managedProperties_)]]"
      disabled="[[disableSignin_(managedProperties_, disabled_)]]">
    <div class="signin-icon cr-icon icon-external"></div>
    $i18n{networkButtonSignin}
  </cr-button>
  <cr-button on-click="onForgetClicked_"
      hidden$="[[!showForget_(managedProperties_)]]"
      disabled="[[disabled_]]">
    $i18n{networkButtonForget}
  </cr-button>
  <cr-button id="connectDisconnect"
      class="action-button" on-click="onConnectDisconnectClick_"
      hidden$="[[!showConnectDisconnect_(managedProperties_)]]"
      disabled="[[!enableConnectDisconnect_(managedProperties_, disabled_)]]">
    [[getConnectDisconnectText_(managedProperties_)]]
  </cr-button>
</div>

<template is="dom-if" if="[[showConfigurableSections_]]" restamp>
  <!-- SIM Info (Cellular only). -->
  <template is="dom-if" if="[[showCellularSim_(managedProperties_)]]"
      restamp>
    <div class="cr-row">
      <network-siminfo class="flex"
          network-state="[[getNetworkState_(managedProperties_)]]"
          device-state="[[deviceState_]]"
          global-policy="[[globalPolicy_]]"
          disabled="[[disabled_]]">
      </network-siminfo>
    </div>
  </template>

  <!-- Choose Mobile Network (Cellular only) -->
  <template is="dom-if"
      if="[[showCellularChooseNetwork_(managedProperties_)]]">
    <div class="cr-row">
      <network-choose-mobile class="flex" device-state="[[deviceState_]]"
          managed-properties="[[managedProperties_]]"
          disabled="[[disabled_]]">
      </network-choose-mobile>
    </div>
  </template>

  <!-- APN (Cellular only) -->
  <template is="dom-if"
      if="[[shouldShowApnList_(managedProperties_,
          isApnRevampEnabled_)]]">
    <div class="cr-row">
      <network-apnlist class="flex" editable on-apn-change="onApnChange_"
          managed-properties="[[managedProperties_]]"
          disabled="[[disabled_]]">
      </network-apnlist>
    </div>
  </template>
  <template is="dom-if"
      if="[[shouldShowApnSection_(managedProperties_,
          isApnRevampEnabled_)]]">
    <cr-expand-button id="apnRow" class="settings-box cr-row"
        expanded="{{apnExpanded_}}">
      <div class="property-box two-line">
        <div class="flex layout vertical">
          <div id="apnRowTitle">$i18n{internetApnPageTitle}</div>
          <div id="apnRowSublabel"
              class="cr-secondary-text"
              warning$="[[showRestrictedConnectivity_(managedProperties_)]]">
            [[getApnRowSublabel_(managedProperties_, apnExpanded_)]]
          </div>
        </div>
        <template is="dom-if" if="[[isApnManaged_(globalPolicy_)]]">
          <cr-policy-indicator id="apnManagedIcon"
              indicator-type="devicePolicy">
          </cr-policy-indicator>
        </template>
      </div>
    </cr-expand-button>
    <iron-collapse opened="[[apnExpanded_]]">
      <apn-list
          id="apnList"
          managed-cellular-properties="[[managedProperties_.typeProperties.cellular]]"
          guid="[[guid]]"
          error-state="[[managedProperties_.errorState]]"
          portal-state="[[managedProperties_.portalState]]"
          should-disallow-apn-modification="[[isApnManaged_(globalPolicy_)]]"
          should-omit-links>
      </apn-list>
      <div id="apnButtonTitle">
        <cr-button id="discoverMoreApnsButton"
            on-click="onDiscoverMoreApnsClicked_"
            class="add-apn-operation cancel-button"
            disabled="[[shouldDisableApnButtons_(isNumCustomApnsLimitReached_,
                globalPolicy_)]]">
          $i18n{apnPageDiscoverMoreApns}
        </cr-button>
        <cr-button id="createCustomApnButton"
            on-click="onCreateCustomApnClicked_"
            class="add-apn-operation cancel-button"
            disabled="[[shouldDisableApnButtons_(isNumCustomApnsLimitReached_,
                globalPolicy_)]]">
          $i18n{apnPageCreateNewApn}
        </cr-button>
      </div>
      <!-- TODO(b/162365553) Add a11y support-->
      <template is="dom-if" if="[[isNumCustomApnsLimitReached_]]" restamp>
        <paper-tooltip
            id="apnTooltip"
            for="apnButtonTitle"
            position="right">
          $i18n{customApnLimitReached}
        </paper-tooltip>
      </template>
    </iron-collapse>
  </template>

  <!-- Proxy -->
  <div class="hr">
    <template is="dom-if"
        if="[[shouldShowProxyPolicyIndicator_(managedProperties_)]]">
      <div class="cr-row continuation">
        <cr-policy-network-indicator-mojo
            property="[[managedProperties_.proxySettings.type]]">
        </cr-policy-network-indicator-mojo>
        <div>$i18n{networkProxyEnforcedPolicy}</div>
      </div>
    </template>
    <div class="cr-row continuation">
      <network-proxy class="flex" use-shared-proxies
          on-proxy-change="onProxyChange_"
          managed-properties="[[managedProperties_]]"
          editable="[[!disabled_]]">
      </network-proxy>
    </div>
  </div>

  <template is="dom-if" if="[[isRememberedOrConnected_(managedProperties_)]]">
    <!-- IP Config -->
    <div class="cr-row">
      <network-ip-config class="flex"
          editable on-ip-change="onIpConfigChange_"
          managed-properties="[[managedProperties_]]"
          disabled="[[disabled_]]">
      </network-ip-config>
    </div>

    <!-- Nameservers -->
    <div class="cr-row">
      <network-nameservers class="flex" editable
          on-nameservers-change="onIpConfigChange_"
          managed-properties="[[managedProperties_]]"
          disabled="[[disabled_]]">
      </network-nameservers>
    </div>
  </template>

  <div class="cr-row">
    <!-- MAC Address. -->
    <div class="property-box single-column two-line"
        id="macAddress"
        hidden$="[[!shouldShowMacAddress_(deviceState_.macAddress)]]">
      <div>$i18n{OncMacAddress}</div>
      <div class="secondary">[[deviceState_.macAddress]]</div>
    </div>
  </div>

  <!-- Other properties to show if present. -->
  <template is="dom-if" if="[[hasInfoFields_(managedProperties_)]]">
    <div class="cr-row continuation">
      <network-property-list-mojo class="flex"
          fields="[[getInfoFields_(managedProperties_)]]"
          property-dict="[[managedProperties_]]"
          disabled="[[disabled_]]">
      </network-property-list-mojo>
    </div>
  </template>
</template>

<template is="dom-if" if="[[isApnRevampEnabled_]]" restamp>
  <cr-toast id="errorToast" duration="5000">
    <span id="errorToastMessage">[[errorToastMessage_]]</span>
  </cr-toast>
</template>
<!--_html_template_end_-->`;
}
