// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr.m.js";import"chrome://resources/ash/common/event_target.js";import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/cr_icon_button/cr_icon_button.js";import"chrome://resources/ash/common/cr_elements/cr_input/cr_input.js";import"chrome://resources/ash/common/cr_elements/icons.html.js";import"chrome://resources/ash/common/cr_elements/cr_shared_vars.css.js";import"/components/buttons/oobe_text_button.js";import"/components/oobe_icons.html.js";import"/components/oobe_illo_icons.html.js";import"/gaia_action_buttons/gaia_action_buttons.js";import"//resources/ash/common/cr_elements/policy/cr_tooltip_icon.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import{Authenticator,AuthFlow,AuthMode,SUPPORTED_PARAMS}from"//lock-reauth/gaia_auth_host/authenticator.js";import{LoginOrUnlock,recordUmaHistogramForSamlRedirectEvent,SamlRedirectEvent}from"/components/online_auth_utils.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert}from"chrome://resources/js/assert.js";import{sendWithPromise}from"chrome://resources/js/cr.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./lock_screen_reauth.html.js";const clearDataType={appcache:true,cache:true,cookies:true};const LockReauthElementBase=I18nMixin(PolymerElement);class LockReauthElement extends LockReauthElementBase{constructor(){super(...arguments);this.authenticatorParams=null}static get is(){return"lock-reauth"}static get template(){return getTemplate()}static get properties(){return{email:{type:String,value:""},authDomain:{type:String,value:""},isErrorDisplayed:{type:Boolean,value:false},isSigninFrameDisplayed:{type:Boolean,value:false},isSaml:{type:Boolean,value:false},isDefaultSsoProvider:{type:Boolean,value:false},isConfirmPassword:{type:Boolean,value:false},isManualInput:{type:Boolean,value:false},isPasswordChanged:{type:Boolean,value:false},passwordConfirmAttempt:{type:Number,value:0},passwordChangeAttempt:{type:Number,value:0}}}ready(){super.ready();this.signinFrame=this.getSigninFrame();const authenticator=this.authenticator=new Authenticator(this.signinFrame);const authenticatorEventListeners={authDomainChange:e=>{this.authDomain=e.detail.newValue},authCompleted:e=>void this.onAuthCompletedMessage(e.detail),loadAbort:e=>void this.onLoadAbortMessage(e.detail),getDeviceId:_=>{sendWithPromise("getDeviceId").then((deviceId=>authenticator.getDeviceIdResponse(deviceId)))},authFlowChange:e=>{this.isSaml=e.detail.newValue===AuthFlow.SAML}};for(const eventName in authenticatorEventListeners){this.authenticator.addEventListener(eventName,authenticatorEventListeners[eventName].bind(this))}chrome.send("startOnlineAuth",[false])}resetState(){this.isErrorDisplayed=false;this.isSaml=false;this.isSigninFrameDisplayed=false;this.isConfirmPassword=false;this.isManualInput=false;this.isPasswordChanged=false;this.authDomain=""}setOrientation(isHorizontal){if(isHorizontal){document.documentElement.setAttribute("orientation","horizontal")}else{document.documentElement.setAttribute("orientation","vertical")}}setWidth(width){document.documentElement.style.setProperty("--lock-screen-reauth-dialog-width",width+"px")}loadAuthenticator(data){assert("webviewPartitionName"in data,"ERROR: missing webview partition name");assert(this.authenticator,"ERROR: Authenticator not yet initialized");this.authenticator.setWebviewPartition(data.webviewPartitionName);const params={};SUPPORTED_PARAMS.forEach((name=>{if(data.hasOwnProperty(name)){params[name]=data[name]}}));params.enableGaiaActionButtons=data.enableGaiaActionButtons;this.authenticatorParams=params;this.email=data.email;this.isDefaultSsoProvider=!!data.doSamlRedirect;this.isSaml=this.isDefaultSsoProvider;if(data.doSamlRedirect){recordUmaHistogramForSamlRedirectEvent(LoginOrUnlock.UNLOCK,this.authenticatorParams.ssoProfile?SamlRedirectEvent.START_WITH_SSO_PROFILE:SamlRedirectEvent.START_WITH_DOMAIN)}this.doGaiaRedirect();chrome.send("authenticatorLoaded")}resetAuthenticator(){this.getSigninFrame().clearData({since:0},clearDataType,(()=>{this.authenticator.resetStates();this.isButtonsEnabled=true;this.isErrorDisplayed=true}))}reloadAuthenticator(){this.getSigninFrame().clearData({since:0},clearDataType,(()=>{this.authenticator.resetStates()}))}getSigninFrame(){const signinFrame=this.shadowRoot.getElementById("signin-frame");assert(signinFrame,"ERROR: signin-frame not found");return signinFrame}setFocusToWebview(){this.signinFrame.focus()}onAuthCompletedMessage(credentials){chrome.send("completeAuthentication",[credentials.gaiaId,credentials.email,credentials.password,credentials.scrapedSAMLPasswords,credentials.usingSAML,credentials.services,credentials.passwordAttributes])}onLoadAbortMessage(data){chrome.send("webviewLoadAborted",[data.error_code])}showSamlConfirmPassword(passwordCount){this.resetState();this.isConfirmPassword=true;this.isManualInput=passwordCount===0;if(this.passwordConfirmAttempt>0){this.$.passwordInput.value="";this.$.passwordInput.invalid=true}this.passwordConfirmAttempt++}passwordChanged(){this.resetState();this.isPasswordChanged=true;this.passwordChangeAttempt++;if(this.passwordChangeAttempt>1){this.$.oldPasswordInput.invalid=true}}onVerify(){assert(this.authenticatorParams,"ERROR: authenticator parameters not yet loaded");this.authenticator.load(AuthMode.DEFAULT,this.authenticatorParams);this.resetState();this.isSigninFrameDisplayed=true}onConfirm(){if(!this.$.passwordInput.validate()){return}if(this.isManualInput){if(!this.$.confirmPasswordInput.validate()){return}if(this.$.confirmPasswordInput.value!==this.$.passwordInput.value){this.$.passwordInput.invalid=true;this.$.confirmPasswordInput.invalid=true;return}}chrome.send("onPasswordTyped",[this.$.passwordInput.value])}onCloseClick(){chrome.send("dialogClose")}onNext(){if(!this.$.oldPasswordInput.validate()){this.$.oldPasswordInput.focusInput();return}chrome.send("updateUserPassword",[this.$.oldPasswordInput.value]);this.$.oldPasswordInput.value=""}doGaiaRedirect(){assert(this.authenticatorParams,"ERROR: authenticator parameters not yet loaded");this.authenticator.load(AuthMode.DEFAULT,this.authenticatorParams);this.resetState();this.isSigninFrameDisplayed=true}passwordPlaceholder(_locale,isManualInput){return this.i18n(isManualInput?"manualPasswordInputLabel":"confirmPasswordLabel")}passwordErrorText(_locale,isManualInput){return this.i18n(isManualInput?"manualPasswordMismatch":"passwordChangedIncorrectOldPassword")}onChangeSigninProviderClicked(){this.resetState();recordUmaHistogramForSamlRedirectEvent(LoginOrUnlock.UNLOCK,SamlRedirectEvent.CHANGE_TO_DEFAULT_GOOGLE_SIGN_IN);chrome.send("startOnlineAuth",[true])}}customElements.define(LockReauthElement.is,LockReauthElement);