import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2020 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<!--
  Simple OOBE dialog which should be used for OOBE UI elements.
  It has correct size and padding. It can display top left icon, and has
  several parts: header, subheader, progress bar; content area; and buttons
  containers at the top for back navigation and for other buttons at the bottom.

  When shown (i.e. when outside container calls .show()):
    1. If this dialog has tags in class "focus-on-show", the first one will be
  focused.
    2. 'show-dialog' is fired.

  Please include oobe-dialog-host-styles shared style if you use oobe-adaptive-dialog.

  Example:
    <style include="oobe-dialog-host-styles"></style>
    <oobe-adaptive-dialog on-show-dialog="onTestDialogShown_" has-buttons>
      <iron-icon ... slot="icon">
      <h1 slot="title">Title</h1>
      <div slot="subtitle">Subtitle</div>
      <div slot="content">
        <div class="focus-on-show">...</div>
        ...
      </div>
      <div slot="back-navigation">
        ...
      </div>
      <div slot="bottom-buttons">
        ...
      </div>
    </oobe-adaptive-dialog>

  Add slot |header| to all which you want to go inside the header.  Similar
  with slots |content|, |bottom-buttons|.

  For single-DPI image |oobe-icon| class should be used. To select between two
  images of different DPI, |oobe-icon-1x| and |oobe-icon-2x| should be used
  instead. For example:

      <iron-icon icon="icon1" ... slot="icon" class="oobe-icon-1x">
      <iron-icon icon-"icon2" ... slot="icon" class="oobe-icon-2x">

  Attributes:
    no-lazy           - prevents lazy instantiation of the dialog.
-->

<style include="oobe-dialog-host-styles cr-shared-style cros-color-overrides">:host{color:var(--oobe-text-color);font-family:var(--oobe-default-font-family);font-size:var(--oobe-default-font-size);font-weight:var(--oobe-default-font-weight);line-height:var(--oobe-default-line-height);height:var(--oobe-adaptive-dialog-height);width:var(--oobe-adaptive-dialog-width)}@media (orientation:landscape){:host{--oobe-adaptive-dialog-content-direction:row;--oobe-adaptive-dialog-item-alignment:unset;--oobe-text-alignment:start;--oobe-adaptive-dialog-content-width:calc(var(--oobe-adaptive-dialog-width) - 4 * var(--oobe-adaptive-dialog-content-padding) - var(--oobe-adaptive-dialog-header-width));--oobe-adaptive-dialog-header-width:clamp(302px,calc(0.4 * (var(--oobe-adaptive-dialog-width) - 4 * var(--oobe-adaptive-dialog-content-padding))),346px);--oobe-adaptive-dialog-content-top-padding:0}:host([single-column]){--oobe-adaptive-dialog-header-width:456px}}@media (orientation:portrait){:host{--oobe-adaptive-dialog-content-direction:column;--oobe-adaptive-dialog-item-alignment:center;--oobe-text-alignment:center;--oobe-adaptive-dialog-content-width:calc(var(--oobe-adaptive-dialog-width) - 2 * var(--oobe-adaptive-dialog-content-padding));--oobe-adaptive-dialog-header-width:clamp(346px,calc(0.6 * (var(--oobe-adaptive-dialog-width) - 2 * var(--oobe-adaptive-dialog-content-padding))),520px)}}#oobe-title ::slotted(h1){color:var(--oobe-header-text-color);font-family:var(--oobe-header-font-family);font-size:var(--oobe-header-font-size);font-weight:var(--oobe-header-font-weight);line-height:var(--oobe-header-line-height);margin:0;text-align:var(--oobe-text-alignment)}#oobe-subtitle ::slotted(*){color:var(--oobe-subheader-text-color);font-family:var(--oobe-subheader-font-family);font-size:var(--oobe-subheader-font-size);font-weight:var(--oobe-subheader-font-weight);line-height:var(--oobe-subheader-line-height);margin:0;overflow-wrap:break-word;text-align:var(--oobe-text-alignment)}#main-container{align-items:var(--oobe-adaptive-dialog-item-alignment);flex-direction:var(--oobe-adaptive-dialog-content-direction)}#header-container{max-height:100%;overflow-y:auto;padding-bottom:0;padding-inline-end:var(--oobe-adaptive-dialog-content-padding);padding-inline-start:var(--oobe-adaptive-dialog-content-padding);padding-top:var(--oobe-adaptive-dialog-header-top-padding);width:var(--oobe-adaptive-dialog-header-width)}#scrollContainer{margin-top:var(--oobe-adaptive-dialog-content-top-padding);overflow-y:auto;padding-bottom:0;padding-inline-end:var(--oobe-adaptive-dialog-content-padding);padding-inline-start:var(--oobe-adaptive-dialog-content-padding);padding-top:0}[read-more-content]{border-bottom:var(--cros-sys-separator) solid 1px;overflow-y:hidden}#readMoreButtonContainer{display:flex;justify-content:center;position:relative;top:-16px}#readMoreButton{border-radius:50%;min-height:32px;min-width:32px;padding:0;transform:rotate(90deg)}#oobe-title{padding-top:var(--oobe-adaptive-dialog-title-top-padding)}:host-context(.jelly-enabled) #oobe-title{padding-top:var(--oobe-adaptive-dialog-item-vertical-padding)}#oobe-progress ::slotted(*){margin-top:32px}:host-context(.jelly-enabled) #oobe-progress ::slotted(*){margin-top:var(--oobe-adaptive-dialog-item-vertical-padding)}#oobe-progress ::slotted(paper-progress){--paper-progress-active-color:var(--cros-slider-color-active);--paper-progress-container-color:var(--cros-slider-track-color-active);height:4px;width:100%}:host-context(.jelly-enabled) #oobe-progress ::slotted(paper-progress){--paper-progress-active-color:var(--cros-sys-primary);--paper-progress-container-color:var(--cros-sys-primary_container)}#oobe-subtitle{padding-top:16px}:host-context(.jelly-enabled) #oobe-subtitle{padding-top:0}:host-context(.jelly-enabled) #oobe-subtitle ::slotted(*){padding-top:var(--oobe-adaptive-dialog-item-vertical-padding)}#oobe-subtitle-illustration ::slotted(*){padding-top:16px}:host-context(.jelly-enabled) #oobe-subtitle-illustration ::slotted(*){padding-top:var(--oobe-adaptive-dialog-item-vertical-padding)}#contentContainer{width:var(--oobe-adaptive-dialog-content-width)}#contentContainer ::slotted(*){max-width:var(--oobe-adaptive-dialog-content-width)}.vertical-mode-centering{align-items:var(--oobe-adaptive-dialog-item-alignment);display:flex;flex-direction:column}.buttons-common{min-height:calc(var(--oobe-button-height) + 2px);z-index:1}.bottom-buttons-container{padding-bottom:var(--oobe-adaptive-dialog-buttons-vertical-padding);padding-inline-end:var(--oobe-adaptive-dialog-buttons-horizontal-padding);padding-inline-start:var(--oobe-adaptive-dialog-buttons-horizontal-padding);padding-top:var(--oobe-adaptive-dialog-buttons-vertical-padding)}.back-button-container{padding-bottom:var(--oobe-adaptive-dialog-back-button-vertical-padding);padding-inline-end:var(--oobe-adaptive-dialog-back-button-horizontal-padding);padding-inline-start:var(--oobe-adaptive-dialog-back-button-horizontal-padding);padding-top:var(--oobe-adaptive-dialog-back-button-vertical-padding)}#oobe-icon-div ::slotted(hd-iron-icon),#oobe-icon-div ::slotted(iron-icon){--iron-icon-height:var(--oobe-adaptive-dialog-icon-size);--iron-icon-width:var(--oobe-adaptive-dialog-icon-size);--iron-icon-fill-color:var(--oobe-adaptive-dialog-icon-fill-color)}</style>
<cr-lazy-render id="lazy">
  <template>
    <div class="buttons-common back-button-container">
      <slot name="back-navigation"></slot>
    </div>
    <div id="main-container" class="layout vertical flex">
      <div id="header-container">
        <div id="oobe-icon-div" class="vertical-mode-centering">
          <slot name="icon"></slot>
        </div>
        <div id="oobe-title" class="vertical-mode-centering">
          <slot name="title"></slot>
        </div>
        <div id="oobe-progress" class="vertical-mode-centering">
          <slot name="progress"></slot>
        </div>
        <div id="oobe-subtitle" class="vertical-mode-centering">
          <slot name="subtitle"></slot>
        </div>
        <div id="oobe-subtitle-illustration" class="vertical-mode-centering">
          <slot name="subtitle-illustration"></slot>
        </div>
      </div>
      <div id="scrollContainer" class="layout vertical flex scrollable">
        <div id="contentContainer" class="layout vertical flex">
          <slot name="content"></slot>
        </div>
        <div id="readMoreButtonContainer">
          <template is="dom-if" if="[[showReadMoreButton]]" restamp>
            <cr-button id="readMoreButton" on-click="onReadMoreClick"
                class="action-button">
              <iron-icon icon="oobe-20:button-arrow-forward"></iron-icon>
            </cr-button>
          </template>
        </div>
      </div>
    </div>
    <div class="buttons-common bottom-buttons-container
        vertical-mode-centering">
      <slot class="layout horizontal end-justified" name="bottom-buttons"
          hidden="[[showReadMoreButton]]">
      </slot>
    </div>
  </template>
</cr-lazy-render>
<!--_html_template_end_-->`}