// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cros_color_overrides.css.js";import"//resources/ash/common/cr_elements/cr_shared_style.css.js";import"//resources/ash/common/cr_scrollable_behavior.js";import"../common_styles/oobe_common_styles.css.js";import"../common_styles/oobe_dialog_host_styles.css.js";import"../oobe_vars/oobe_custom_vars.css.js";import"../oobe_vars/oobe_shared_vars.css.js";import{CrButtonElement}from"//resources/ash/common/cr_elements/cr_button/cr_button.js";import{CrLazyRenderElement}from"//resources/ash/common/cr_elements/cr_lazy_render/cr_lazy_render.js";import{assert}from"//resources/js/assert.js";import{afterNextRender,PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./oobe_adaptive_dialog.html.js";var ReadMoreState;(function(ReadMoreState){ReadMoreState["UNKNOWN"]="unknown";ReadMoreState["SHOWN"]="shown";ReadMoreState["HIDDEN"]="hidden"})(ReadMoreState||(ReadMoreState={}));export class OobeAdaptiveDialog extends PolymerElement{static get is(){return"oobe-adaptive-dialog"}static get template(){return getTemplate()}static get properties(){return{noLazy:{type:Boolean,value:false,observer:"onNoLazyChanged"},readMore:{type:Boolean,value:false},singleColumn:{type:Boolean,reflectToAttribute:true,value:false},showReadMoreButton:{type:Boolean,value:false}}}constructor(){super();this.readMoreState=ReadMoreState.UNKNOWN;this.resizeObserver=undefined}getLazyRender(){const lazyRender=this.shadowRoot?.querySelector("#lazy");assert(lazyRender instanceof CrLazyRenderElement);return lazyRender}getReadMoreButton(){const readMoreButton=this.shadowRoot?.querySelector("#readMoreButton");return readMoreButton instanceof CrButtonElement?readMoreButton:null}getScrollContainer(){const scrollContainer=this.shadowRoot?.querySelector("#scrollContainer");return scrollContainer instanceof HTMLDivElement?scrollContainer:null}getContentContainer(){const contentContainer=this.shadowRoot?.querySelector("#contentContainer");return contentContainer instanceof HTMLDivElement?contentContainer:null}addResizeObserver(){if(this.resizeObserver){return}if(this.readMore){this.readMoreState=ReadMoreState.UNKNOWN}else{this.readMoreState=ReadMoreState.HIDDEN}const scrollContainer=this.getScrollContainer();const contentContainer=this.getContentContainer();if(!scrollContainer||!contentContainer){return}scrollContainer.addEventListener("scroll",this.applyScrollClassTags.bind(this));this.resizeObserver=new ResizeObserver((()=>void this.onResize()));this.resizeObserver.observe(scrollContainer);this.resizeObserver.observe(contentContainer)}onResize(){this.maybeUpgradeReadMoreState(false);if(this.readMoreState===ReadMoreState.HIDDEN){this.applyScrollClassTags()}}applyScrollClassTags(){const scrollContainer=this.getScrollContainer();assert(scrollContainer instanceof HTMLDivElement);scrollContainer.classList.toggle("can-scroll",scrollContainer.clientHeight<scrollContainer.scrollHeight);scrollContainer.classList.toggle("is-scrolled",scrollContainer.scrollTop>0);scrollContainer.classList.toggle("scrolled-to-bottom",scrollContainer.scrollTop+scrollContainer.clientHeight>=scrollContainer.scrollHeight)}maybeUpgradeReadMoreState(readMoreClicked){if(this.readMoreState===ReadMoreState.HIDDEN){return}if(readMoreClicked){this.readMoreState=ReadMoreState.HIDDEN;this.removeReadMoreButton();return}const content=this.getContentContainer();assert(content instanceof HTMLDivElement);if(this.readMoreState===ReadMoreState.UNKNOWN){if(content.clientHeight<content.scrollHeight){this.readMoreState=ReadMoreState.SHOWN;this.addReadMoreButton()}else{this.readMoreState=ReadMoreState.HIDDEN}}else if(this.readMoreState===ReadMoreState.SHOWN){if(content.clientHeight>=content.scrollHeight||content.scrollTop>0){this.readMoreState=ReadMoreState.HIDDEN;this.removeReadMoreButton()}}}focus(){this.show()}onBeforeShow(){this.getLazyRender().get();this.addResizeObserver()}scrollToBottom(){const scrollContainer=this.getScrollContainer();assert(scrollContainer instanceof HTMLDivElement);scrollContainer.scrollTop=scrollContainer.scrollHeight}focusOnShow(){const focusedElements=this.querySelectorAll(".focus-on-show");let focused=false;for(let i=0;i<focusedElements.length;++i){if(focusedElements[i].hidden){continue}focused=true;afterNextRender(this,(()=>focusedElements[i].focus()));break}if(!focused&&focusedElements.length>0){afterNextRender(this,(()=>focusedElements[0].focus()))}}show(){this.focusOnShow();this.dispatchEvent(new CustomEvent("show-dialog",{bubbles:true,composed:true}))}onNoLazyChanged(){if(this.noLazy){this.getLazyRender().get()}}addReadMoreButton(){const contentContainer=this.getContentContainer();assert(contentContainer instanceof HTMLDivElement);contentContainer.toggleAttribute("read-more-content",true);this.showReadMoreButton=true;afterNextRender(this,(()=>{const readMoreButton=this.getReadMoreButton();assert(readMoreButton);readMoreButton.focus()}));contentContainer.addEventListener("keyup",(event=>{if(!this.showReadMoreButton){return}if(event.which===9){if(contentContainer.scrollTop>0){this.maybeUpgradeReadMoreState(true)}}}))}removeReadMoreButton(){const contentContainer=this.getContentContainer();assert(contentContainer instanceof HTMLDivElement);contentContainer.removeAttribute("read-more-content");this.showReadMoreButton=false;if(this.shadowRoot?.activeElement===this.getReadMoreButton()){this.focusOnShow()}this.scrollToBottom()}onReadMoreClick(){this.maybeUpgradeReadMoreState(true)}}customElements.define(OobeAdaptiveDialog.is,OobeAdaptiveDialog);