import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2021 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-dialog-host-styles">#spinner{max-height:286px;max-width:286px}</style>
<oobe-adaptive-dialog id="dialog" role="dialog">
  <slot slot="icon" name="icon"></slot>
  <h1 slot="title">
    <slot name="title" aria-label="[[getAriaLabel(locale, titleLabelKey, titleKey)]]">
      <template is="dom-if" if="[[titleKey]]">
        [[i18nDynamic(locale, titleKey)]]
      </template>
    </slot>
  </h1>
  <div slot="subtitle">
    <slot name="subtitle">
      <template is="dom-if" if="[[subtitleKey]]">
        <div>[[i18nDynamic(locale, subtitleKey)]]</div>
      </template>
    </slot>
  </div>
  <div slot="content" class="flex layout vertical center center-justified">
    <oobe-cr-lottie id="spinner" hide-play-pause-icon
        animation-url="../../animations/spinner.json">
    </oobe-cr-lottie>
  </div>
  <!-- Cancel button -->
  <div slot="bottom-buttons"
      class="flex layout horizontal end-justified">
    <!-- Optional custom cancel button, otherwise the default below is used. -->
    <slot name="cancel-button">
      <oobe-text-button id="cancelButton" on-click="cancel"
          text-key="cancelButton" hidden="[[!canCancel]]">
      </oobe-text-button>
    </slot>
  </div>
</oobe-adaptive-dialog>
<!--_html_template_end_-->`}