// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cr_icon_button/cr_icon_button.js";import"//resources/ash/common/cr_elements/icons.html.js";import"//resources/ash/common/cr_elements/cr_shared_style.css.js";import"./buttons/oobe_back_button.js";import"./buttons/oobe_text_button.js";import"./common_styles/oobe_common_styles.css.js";import"./common_styles/oobe_dialog_host_styles.css.js";import"./dialogs/oobe_content_dialog.js";import"./quick_start_entry_point.js";import{Authenticator,AuthFlow}from"//oobe/gaia_auth_host/authenticator.js";import{assert}from"//resources/js/assert.js";import{sendWithPromise}from"//resources/js/cr.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./gaia_dialog.html.js";import{OobeDialogHostMixin}from"./mixins/oobe_dialog_host_mixin.js";import{OobeI18nMixin}from"./mixins/oobe_i18n_mixin.js";import{OobeTypes}from"./oobe_types.js";const GaiaDialogBase=OobeDialogHostMixin(OobeI18nMixin(PolymerElement));const CHROMEOS_GAIA_PASSWORD_METRIC="ChromeOS.Gaia.PasswordFlow";export class GaiaDialog extends GaiaDialogBase{static get is(){return"gaia-dialog"}static get template(){return getTemplate()}static get properties(){return{videoEnabled:{type:Boolean,value:false,notify:true},authFlow:{type:Number,value:0,notify:true},gaiaDialogButtonsType:{type:String,value:OobeTypes.GaiaDialogButtonsType.DEFAULT},isClosable:{type:Boolean,value:false},isSamlSsoVisible:{type:Boolean,value:false},isDefaultSsoProvider:{type:Boolean,value:false},hideBackButtonIfCantGoBack:{type:Boolean,value:false},authDomain:{type:String,value:"",notify:true},navigationEnabled:{type:Boolean,value:true,notify:true},navigationHidden:{type:Boolean,value:false},webviewName:{type:String},primaryActionButtonLabel:{type:String,value:null},primaryActionButtonEnabled:{type:Boolean,value:false},secondaryActionButtonLabel:{type:String,value:null},secondaryActionButtonEnabled:{type:Boolean,value:false},canGoBack:{type:Boolean,value:false,notify:true},isPopUpOverlayVisible:{type:Boolean,computed:"showOverlay(navigationEnabled, isSamlSsoVisible)"},samlBackButtonHidden:{type:Boolean,computed:"isSamlBackButtonHidden(isDefaultSsoProvider, isClosable)"},clientPrimaryActionButtonLabel:{type:String,value:null},clientAdditionalPrimaryActionButtonLabel:{type:String,value:null},isQuickStartEnabled:Boolean}}static get observers(){return["updatePrimaryButton(locale, primaryActionButtonLabel, canGoBack, gaiaDialogButtonsType)"]}constructor(){super();this.clickPrimaryActionButtonForTesting=false;this.authenticator=undefined;this.isQuickStartEnabled=false}getAuthenticator(){return this.authenticator}ready(){super.ready();const webview=this.getFrame();this.authenticator=new Authenticator(webview);const authenticatorEventListeners={identifierEntered:e=>{this.dispatchEvent(new CustomEvent("identifierentered",{bubbles:true,composed:true,detail:e.detail}))},loadAbort:e=>{this.dispatchEvent(new CustomEvent("webviewerror",{bubbles:true,composed:true,detail:e.detail}))},ready:()=>{this.dispatchEvent(new CustomEvent("ready",{bubbles:true,composed:true}))},showView:()=>{this.dispatchEvent(new CustomEvent("showview",{bubbles:true,composed:true}))},menuItemClicked:e=>{if(e.detail==="ee"){this.dispatchEvent(new CustomEvent("startenrollment",{bubbles:true,composed:true}))}},backButton:e=>{this.canGoBack=!!e.detail;this.getFrame().focus()},setPrimaryActionEnabled:e=>{this.primaryActionButtonEnabled=e.detail;this.maybeClickPrimaryActionButtonForTesting()},setPrimaryActionLabel:e=>{this.primaryActionButtonLabel=e.detail;this.maybeClickPrimaryActionButtonForTesting()},setSecondaryActionEnabled:e=>{this.secondaryActionButtonEnabled=e.detail},setSecondaryActionLabel:e=>{this.secondaryActionButtonLabel=e.detail},setAllActionsEnabled:e=>{this.primaryActionButtonEnabled=e.detail;this.secondaryActionButtonEnabled=e.detail;this.maybeClickPrimaryActionButtonForTesting()},videoEnabledChange:e=>{this.videoEnabled=e.detail.newValue},authFlowChange:e=>{this.authFlow=e.detail.newValue},authDomainChange:e=>{this.authDomain=e.detail.newValue},dialogShown:()=>{this.navigationEnabled=false;chrome.send("enableShelfButtons",[false])},dialogHidden:()=>{this.navigationEnabled=true;chrome.send("enableShelfButtons",[true])},exit:()=>{this.dispatchEvent(new CustomEvent("exit",{bubbles:true,composed:true}))},removeUserByEmail:e=>{this.dispatchEvent(new CustomEvent("removeuserbyemail",{bubbles:true,composed:true,detail:e.detail}))},apiPasswordAdded:()=>{if(this.authFlow!==AuthFlow.DEFAULT){return}chrome.send("metricsHandler:recordBooleanHistogram",[CHROMEOS_GAIA_PASSWORD_METRIC,false]);chrome.send("passwordEntered")},authCompleted:e=>{if(this.authFlow===AuthFlow.DEFAULT){chrome.send("metricsHandler:recordBooleanHistogram",[CHROMEOS_GAIA_PASSWORD_METRIC,true])}this.dispatchEvent(new CustomEvent("authcompleted",{bubbles:true,composed:true,detail:e.detail}))}};for(const eventName in authenticatorEventListeners){this.authenticator.addEventListener(eventName,authenticatorEventListeners[eventName].bind(this))}sendWithPromise("getIsSshConfigured").then(this.updateSshWarningVisibility.bind(this))}updateSshWarningVisibility(show){const sshWarning=this.shadowRoot?.querySelector("#sshWarning");if(sshWarning instanceof HTMLElement){sshWarning.hidden=!show}}show(){this.navigationEnabled=true;chrome.send("enableShelfButtons",[true]);this.getFrame().focus()}getFrame(){const frame=this.shadowRoot?.querySelector("#signin-frame");assert(!!frame);return frame}clickPrimaryButtonForTesting(){this.clickPrimaryActionButtonForTesting=true;this.maybeClickPrimaryActionButtonForTesting()}maybeClickPrimaryActionButtonForTesting(){if(!this.clickPrimaryActionButtonForTesting){return}const button=this.shadowRoot.querySelector("#primary-action-button");if(button.hidden||button.disabled){return}this.clickPrimaryActionButtonForTesting=false;button.click()}getSamlNoticeMessage(locale,videoEnabled,authDomain){if(videoEnabled){return this.i18nDynamic(locale,"samlNoticeWithVideo",authDomain)}return this.i18nDynamic(locale,"samlNotice",authDomain)}close(){this.dispatchEvent(new CustomEvent("closesaml",{bubbles:true,composed:true}))}onChangeSigninProviderClicked(){this.dispatchEvent(new CustomEvent("changesigninprovider",{bubbles:true,composed:true}))}onBackButtonClicked(){if(this.canGoBack){this.getFrame().back();return}this.dispatchEvent(new CustomEvent("backcancel",{bubbles:true,composed:true}))}onQuickStartClicked(){this.dispatchEvent(new CustomEvent("quick-start-clicked",{bubbles:true,composed:true}))}onPrimaryActionButtonClicked(){if(this.gaiaDialogButtonsType===OobeTypes.GaiaDialogButtonsType.ENTERPRISE_PREFERRED){this.setLicenseType(OobeTypes.LicenseType.ENTERPRISE)}else if(this.gaiaDialogButtonsType===OobeTypes.GaiaDialogButtonsType.KIOSK_PREFERRED){this.setLicenseType(OobeTypes.LicenseType.KIOSK)}assert(this.authenticator);this.authenticator.sendMessageToWebview("primaryActionHit")}onAdditionalPrimaryActionButtonClicked(){if(this.gaiaDialogButtonsType===OobeTypes.GaiaDialogButtonsType.ENTERPRISE_PREFERRED){this.setLicenseType(OobeTypes.LicenseType.KIOSK)}else if(this.gaiaDialogButtonsType===OobeTypes.GaiaDialogButtonsType.KIOSK_PREFERRED){this.setLicenseType(OobeTypes.LicenseType.ENTERPRISE)}assert(this.authenticator);this.authenticator.sendMessageToWebview("primaryActionHit")}onSecondaryActionButtonClicked(){assert(this.authenticator);this.authenticator.sendMessageToWebview("secondaryActionHit")}
/**
     * @param licenseType - license to use.
     */setLicenseType(licenseType){this.dispatchEvent(new CustomEvent("licensetypeselected",{bubbles:true,composed:true,detail:licenseType}))}isButtonEnabled(navigationEnabled,buttonEnabled){return navigationEnabled&&buttonEnabled}isBackButtonHidden(navigationHidden,hideBackButtonIfCantGoBack,canGoBack){return navigationHidden||hideBackButtonIfCantGoBack&&!canGoBack}isSamlBackButtonHidden(isDefaultSsoProvider,isClosable){return isDefaultSsoProvider&&!isClosable}showOverlay(navigationEnabled,isSamlSsoVisible){return!navigationEnabled||isSamlSsoVisible}updatePrimaryButton(locale,primaryActionButtonLabel,canGoBack,gaiaDialogButtonsType){this.clientPrimaryActionButtonLabel=primaryActionButtonLabel;this.clientAdditionalPrimaryActionButtonLabel="";if(!canGoBack||!primaryActionButtonLabel){return}if(gaiaDialogButtonsType===OobeTypes.GaiaDialogButtonsType.ENTERPRISE_PREFERRED){this.clientPrimaryActionButtonLabel=this.i18nDynamic(locale,"enterpriseEnrollmentButton");this.clientAdditionalPrimaryActionButtonLabel=this.i18nDynamic(locale,"kioskEnrollmentButton");return}if(gaiaDialogButtonsType===OobeTypes.GaiaDialogButtonsType.KIOSK_PREFERRED){this.clientPrimaryActionButtonLabel=this.i18nDynamic(locale,"kioskEnrollmentButton");this.clientAdditionalPrimaryActionButtonLabel=this.i18nDynamic(locale,"enterpriseEnrollmentButton")}}}customElements.define(GaiaDialog.is,GaiaDialog);