// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assertInstanceof}from"//resources/js/assert.js";import{dedupingMixin}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeBaseMixin}from"./oobe_base_mixin.js";export const MultiStepMixin=dedupingMixin((superClass=>{const superClassBase=OobeBaseMixin(superClass);class MultiStepMixinInternal extends superClassBase{constructor(){super(...arguments);this.stepElements={};this.shown=false}static get properties(){return{uiStep:{type:String,value:""}}}get UI_STEPS(){return{}}listSteps(){return Object.values(this.UI_STEPS)}defaultUIStep(){console.error("defaultUIStep() must be overridden in screen");return"Invalid"}ready(){super.ready();this.classList.add("multi-state-element");this.refreshStepBindings()}onBeforeShow(...data){super.onBeforeShow(data);this.shown=true;if(!this.uiStep){this.setUIStep(this.defaultUIStep())}else{this.showUiStep(this.uiStep)}}onBeforeHide(){super.onBeforeHide();if(this.uiStep){this.hideUIStep(this.uiStep)}this.shown=false}get defaultControl(){return this.stepElements[this.defaultUIStep()][0]}applyToStepElements(func,step=this.uiStep){for(const element of this.stepElements[step]||[]){func(element)}}setUIStep(step){if(this.uiStep){if(this.uiStep===step){return}this.hideUIStep(this.uiStep)}this.uiStep=step;this.shadowRoot?.host?.setAttribute("multistep",step);this.showUiStep(this.uiStep)}showUiStep(step){if(!this.shown){return}for(const element of this.stepElements[step]||[]){if("onBeforeShow"in element&&typeof element.onBeforeShow==="function"){element.onBeforeShow()}element.hidden=false;if("show"in element&&typeof element.show==="function"){element.show()}}}hideUIStep(step){for(const element of this.stepElements[step]||[]){if("onBeforeHide"in element&&typeof element.onBeforeHide==="function"){element.onBeforeHide()}element.hidden=true}}refreshStepBindings(){this.stepElements={};const matches=this.shadowRoot?.querySelectorAll("[for-step]")||[];for(const child of matches){assertInstanceof(child,HTMLElement,"Each element assigned to a multi step has to be of type "+"HTMLElement");const stepsList=child.getAttribute("for-step")?.split(",")||[];for(const stepChunk of stepsList){const step=stepChunk.trim();const list=this.stepElements[step]||[];list.push(child);this.stepElements[step]=list}child.hidden=true}}}return MultiStepMixinInternal}));