import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2022 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<!--
  OOBE polymer element which is used to show a list of recommended apps.
-->

<style include="cros-color-overrides oobe-common-styles">:host{--checkbox-column-width:40px;--checkbox-size:16px}#appsListContainer{display:grid;gap:8px 0;grid-auto-flow:row;grid-template-rows:40px 1fr;height:100%}#appsList{overflow-y:auto}#appsListContainer .app-item{display:grid;gap:4px 16px;grid-template-areas:'.        .    title       .     ' 'checkbox icon category    .     ' '.        .    description .     ';grid-auto-flow:column;grid-template-columns:var(--checkbox-column-width) 48px 1fr 26px;grid-template-rows:22px 22px auto;padding-bottom:16px;padding-top:16px}#appsListContainer .app-item:not(:first-child){border-top:1px solid var(--cros-color-primary-dark)}:host-context(.jelly-enabled) #appsListContainer .app-item:not(:first-child){border-top:1px solid var(--cros-sys-separator)}cr-checkbox{--cr-checkbox-mark-color:var(--cr-checked-color);--cr-checkbox-size:var(--checkbox-size)}#selectAll{margin-inline-start:calc((var(--checkbox-column-width) - var(--checkbox-size)) / 2)}#unselectAll{border-bottom:solid 2px var(--cr-checked-color);height:19px;margin-inline-start:calc((var(--checkbox-column-width) - var(--checkbox-size)) / 2 + 4px);position:absolute;width:8px}:host-context(.jelly-enabled) #unselectAll{border-bottom:solid 2px var(--cros-sys-primary)}cr-checkbox.some-selected{--cr-checkbox-unchecked-box-color:var(--cr-checked-color)}.app-item cr-checkbox{align-self:center;grid-area:checkbox;height:var(--checkbox-size);justify-self:center;width:var(--checkbox-size)}webview.app-icon{align-items:center;align-self:center;grid-area:icon;height:48px;user-select:none;width:48px}.app-title{color:var(--oobe-header-text-color);font-size:var(--oobe-modal-dialog-header-font-size);font-weight:var(--oobe-modal-dialog-header-font-weight);grid-area:title;line-height:22px}:host-context(.jelly-enabled) .app-title{font-family:var(--oobe-apps-list-app-title-font-family);font-size:var(--oobe-apps-list-app-title-font-size);font-weight:var(--oobe-apps-list-app-title-font-weight);line-height:var(--oobe-apps-list-app-title-line-height)}.secondary-text{color:var(--oobe-text-color);font-family:var(--oobe-default-font-family);font-size:12px;font-weight:var(--oobe-default-font-weight);line-height:18px}:host-context(.jelly-enabled) .secondary-text{color:var(--oobe-subheader-text-color);font-family:var(--oobe-apps-list-secondary-text-font-family);font-size:var(--oobe-apps-list-secondary-text-font-size);font-weight:var(--oobe-apps-list-secondary-text-font-weight);line-height:var(--oobe-apps-list-secondary-text-line-height)}.app-tags{grid-area:category}.app-tags ul{list-style:none;margin:0;padding:0}.app-tags li{display:inline-block}.app-tags ul>li::before{content:'|'/'';margin-inline-end:6px;margin-inline-start:6px}:host-context(.jelly-enabled) .app-tags ul>li::before{color:var(--cros-sys-separator)}.app-tags ul>li:first-of-type::before{content:'';margin:0}.app-description{grid-area:description}.truncated{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}</style>
<div id="appsListContainer">
  <div id="unselectAll" hidden="[[unselectSymbolHidden(appsSelected)]]"></div>
  <cr-checkbox
    id="selectAll"
    checked="{{allSelected}}"
    on-change="updateSelection"
  >
    <slot name="selectAllTitle"></slot>
  </cr-checkbox>
  <div id="appsList" class="scrollable">
    <div id="scrollContent">
      <template is="dom-repeat" items="[[appList]]">
        <div class="app-item">
          <cr-checkbox
            id="[[item.package_name]]"
            checked="{{item.checked}}"
            class="no-label"
            aria-description="[[item.title]]"
            on-change="updateCount"
          >
          </cr-checkbox>
          <webview
            role="img"
            class="app-icon"
            src="[[getWrappedIcon(item.icon_url)]]"
            aria-hidden="true"
            tabindex="-1"
            on-contentload="onImageLoaded"
          >
          </webview>
          <div class="app-title">[[item.title]]</div>
          <div class="app-tags secondary-text truncated">
            <ul>
              <template is="dom-repeat" items="[[item.tags]]">
                <li>[[item]]</li>
              </template>
            </ul>
          </div>
          <div class="app-description secondary-text">
            [[item.description]]
          </div>
          </div>
        </div>
      </template>
    </div>
  </div>
</div>
<!--_html_template_end_-->`}