import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2020 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="oobe-common-styles">#container{background:white;border:1px solid var(--google-grey-200);border-radius:16px;display:flex;flex-direction:column;height:100%;position:relative;white-space:nowrap;width:100%}:host-context(.jelly-enabled) #container{background:var(--cros-sys-base_elevated);border:none;border-radius:20px}#scrollContainer{border-top:transparent;flex:1 1 auto;overflow-x:hidden;overflow-y:auto;will-change:transform}#slidesContainer ::slotted(*){position:absolute}#navigationContainer{background-color:white;padding:8px;display:flex;justify-content:center;width:100%}:host-context(.jelly-enabled) #navigationContainer{background:var(--cros-sys-base_elevated)}#dotsContainer{display:flex}::slotted(.animated){transition:transform 500ms cubic-bezier(0.6,0,0,1.0)}::slotted(.backward){transform:var(--oobe-backward-slide-animation)}::slotted(.forward){transform:var(--oobe-forward-slide-animation)}::slotted(.hide-slide){animation:500ms ease 0s normal forwards 1 slide-fadeout}@keyframes slide-fadeout{0%{opacity:1.0}60%{opacity:1.0}100%{opacity:0}}.buttons{height:20px;margin-inline-end:0;margin-inline-start:0;width:20px}:host-context(.jelly-enabled) .slider-dot{margin-inline-end:1px;margin-inline-start:1px}.slider-dot{background:var(--cros-color-primary-inverted);border-radius:5px;cursor:pointer;height:10px;margin:5px;transition:background 200ms;transition-delay:100ms;width:10px}.slider-dot[active]{background:var(--cros-icon-color-blue)}.slider-dot:focus{box-shadow:0 0 7px 1px rgba(var(--cros-icon-color-blue-rgb),.75);outline:none}:host-context(.jelly-enabled) .slider-dot{height:8px;width:8px;margin:6px 7px;background:transparent;outline:1px solid var(--cros-sys-primary);outline-offset:-1px}:host-context(.jelly-enabled) .slider-dot:hover{background:var(--cros-sys-highlight_shape)}:host-context(.jelly-enabled) .slider-dot[active]{background:var(--cros-sys-primary)}:host-context(.jelly-enabled) .slider-dot:focus{box-shadow:none}.arrow-button{--cr-icon-button-fill-color:var(--cros-app-shield-color)}:host-context(.jelly-enabled) .arrow-button{--cr-icon-button-fill-color:var(--cros-sys-secondary)}</style>
<div id="container">
  <div id="scrollContainer" class="scrollable">
    <div id="slidesContainer">
      <slot id="slot" name="slides"></slot>
    </div>
  </div>
  <div id="navigationContainer">
    <cr-icon-button id="left" class="buttons" iron-icon="cr:chevron-left"
        class="arrow-button" on-click="movePrev"></cr-icon-button>
    <div id="dotsContainer" role="radiogroup">
      <template is="dom-repeat" items="[[dots]]">
        <span class="slider-dot" tabindex="0" on-keypress="onKeypress"
            on-click="onClick" active$="[[isActive(index, slideIndex)]]"
            aria-label="[[getDotLabel(index, slideIndex)]]" aria-live="off"
            aria-checked="[[isActive(index, slideIndex)]]"
            role="radio"></span>
      </template>
    </div>
    <cr-icon-button id="right" class="buttons" iron-icon="cr:chevron-right"
        class="arrow-button" on-click="moveNext"></cr-icon-button>
  </div>
</div>
<!--_html_template_end_-->`}