// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cr_icon_button/cr_icon_button.js";import"//resources/ash/common/cr_elements/icons.html.js";import"./common_styles/oobe_common_styles.css.js";import{loadTimeData}from"//resources/ash/common/load_time_data.m.js";import{assert}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{OobeScrollableMixin}from"./mixins/oobe_scrollable_mixin.js";import{getTemplate}from"./oobe_carousel.html.js";const OobeCarouselBase=OobeScrollableMixin(PolymerElement);export class OobeCarousel extends OobeCarouselBase{static get is(){return"oobe-carousel"}static get template(){return getTemplate()}static get properties(){return{slideIndex:{type:Number,value:0,observer:"onSlideIndexChanged"},autoTransition:{type:Boolean,value:false,observer:"restartAutoTransition"},slideDurationInSeconds:{type:Number,value:8,observer:"restartAutoTransition"},slideLabel:{type:String},selectedButtonLabel:{type:String},unselectedButtonLabel:{type:String}}}constructor(){super();this.dots=[];this.slides=[];this.totalSlides=0;this.timerId=null}ready(){super.ready();this.prepareCarousel();this.restartAutoTransition();this.hideNonActiveSlides();const slidesContainer=this.shadowRoot?.querySelector("#slidesContainer");assert(slidesContainer instanceof HTMLDivElement);slidesContainer.addEventListener("mouseenter",(()=>this.stopAutoTransition()));slidesContainer.addEventListener("mouseleave",(()=>this.startAutoTransition()));const scrollContainer=this.shadowRoot?.querySelector("#scrollContainer");assert(scrollContainer instanceof HTMLDivElement);this.initScrollableObservers(scrollContainer,slidesContainer)}prepareCarousel(){const slot=this.shadowRoot?.querySelector("#slot");assert(slot instanceof HTMLSlotElement);const slotted=slot.assignedElements();assert(Array.isArray(slotted)&&slotted.every((elem=>elem instanceof HTMLElement)));this.slides=slotted;this.totalSlides=this.slides.length;this.dots=[...Array(this.totalSlides).keys()];for(let i=0;i<this.totalSlides;++i){this.slides[i].setAttribute("aria-label",this.getSlideLabel(i));this.slides[i].setAttribute("role","group")}}getSlideLabel(index){return loadTimeData.getStringF(this.slideLabel,index+1,this.totalSlides)}hideNonActiveSlides(){for(let idx=0;idx<this.totalSlides;++idx){if(idx!==this.slideIndex){OobeCarousel.hideSlide(this.slides[idx])}}}restartAutoTransition(){this.stopAutoTransition();this.startAutoTransition()}startAutoTransition(){if(this.autoTransition&&this.slideDurationInSeconds!=null){this.timerId=setInterval((()=>this.moveNext()),this.slideDurationInSeconds*1e3)}}stopAutoTransition(){if(this.timerId!=null){clearInterval(this.timerId);this.timerId=null}}animateSlides(toIndex,fromIndex){if(fromIndex===0&&toIndex===this.totalSlides-1){this.animateInternal(toIndex,fromIndex,false);return}if(fromIndex===this.totalSlides-1&&toIndex===0){this.animateInternal(toIndex,fromIndex,true);return}if(toIndex<fromIndex){this.animateInternal(toIndex,fromIndex,false)}if(toIndex>fromIndex){this.animateInternal(toIndex,fromIndex,true)}}animateInternal(toIndex,fromIndex,forward){if(forward){this.animateInternalWithStyles(toIndex,fromIndex,"forward","backward")}else{this.animateInternalWithStyles(toIndex,fromIndex,"backward","forward")}}static hideSlide(slide){slide.setAttribute("aria-hidden","true");slide.hidden=true}static showSlide(slide){slide.removeAttribute("aria-hidden");slide.hidden=false}static cleanStyles(slide){slide.classList.remove("animated","forward","backward","hide-slide")}static removeAnimateTo(event){const toElement=event.target;assert(toElement instanceof HTMLElement);OobeCarousel.cleanStyles(toElement);toElement.removeEventListener("transitionend",OobeCarousel.removeAnimateTo)}static removeAnimateFrom(event){const fromElement=event.target;assert(fromElement instanceof HTMLElement);OobeCarousel.hideSlide(fromElement);OobeCarousel.cleanStyles(fromElement);fromElement.removeEventListener("transitionend",OobeCarousel.removeAnimateFrom)}cleanUpState(fromIndex){for(let idx=0;idx<this.totalSlides;++idx){const slide=this.slides[idx];slide.removeEventListener("transitionend",OobeCarousel.removeAnimateFrom);slide.removeEventListener("transitionend",OobeCarousel.removeAnimateTo);if(idx!==fromIndex){OobeCarousel.hideSlide(slide)}OobeCarousel.cleanStyles(slide)}OobeCarousel.showSlide(this.slides[fromIndex])}animateInternalWithStyles(toIndex,fromIndex,toStyle,fromStyle){if(fromIndex==null){return}this.cleanUpState(fromIndex);const toElement=this.slides[toIndex];const fromElement=this.slides[fromIndex];toElement.removeAttribute("aria-hidden");toElement.removeAttribute("hidden");toElement.classList.add(toStyle);void toElement.offsetWidth;this.applyScrollClassTags();toElement.classList.add("animated");fromElement.classList.add("animated");toElement.classList.remove(toStyle);fromElement.classList.add(fromStyle);fromElement.classList.add("hide-slide");toElement.addEventListener("transitionend",OobeCarousel.removeAnimateTo);fromElement.addEventListener("transitionend",OobeCarousel.removeAnimateFrom);fromElement.addEventListener("transitionend",(()=>this.applyScrollClassTags()),{once:true})}onKeypress(e){if(e.key==="Space"||e.key==="Enter"){this.slideIndex=e.model.item}}onClick(e){this.slideIndex=e.model.item;setTimeout((element=>element.blur()),this.slideDurationInSeconds*1e3,e.currentTarget)}isActive(index){return index===this.slideIndex}getDotLabel(index){if(index===this.slideIndex){return loadTimeData.getStringF(this.selectedButtonLabel,index+1,this.totalSlides)}return loadTimeData.getStringF(this.unselectedButtonLabel,index+1,this.totalSlides)}onSlideIndexChanged(toIndex,fromIndex){this.restartAutoTransition();this.animateSlides(toIndex,fromIndex)}moveNext(){this.slideIndex=(this.slideIndex+1)%this.totalSlides}movePrev(){this.slideIndex=(this.slideIndex+this.totalSlides-1)%this.totalSlides}}customElements.define(OobeCarousel.is,OobeCarousel);