import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!-- Copyright 2024 The Chromium Authors
     Use of this source code is governed by a BSD-style license that can be
     found in the LICENSE file. -->


<!--
  OOBE polymer element which is used to show a list of categories
  that would be displayed in Persona Screen.
  It has all styling for the categories_item element and can display
  for each categories : Icon and a title and subtitle.
-->

<style include="oobe-dialog-host-styles cros-color-overrides">:host{--cr-card-button-height:150px;--iron-icon-width:40px;--iron-icon-height:40px}#categoriesList{column-gap:16px;display:grid;grid-template-columns:repeat(2,1fr);width:100%}.category-title{color:var(--cros-sys-on_surface);font:var(--cros-button-2-font)}.category-subtitle{color:var(--cros-sys-on_surface_variant);font:var(--cros-annotation-1-font)}.category-item{background-color:var(--cros-sys-on_primary) !important;border-radius:16px;border-width:0;box-shadow:none;gap:16px;display:flex;height:84px;margin-bottom:8px;margin-inline-end:4px;margin-inline-start:4px;margin-top:8px;align-items:center;padding:16px}.category-item:hover{background-color:var(--cros-sys-hover_on_subtle) !important}.text-container{display:flex;flex-direction:column;justify-content:center}.category-item:focus{border:2px solid var(--cros-sys-focus_ring)}.category-item[checked=true] .selected-icon{display:flex}.category-item[checked=true] .logo-container{display:none}.selected-icon{align-items:center;align-self:center;display:none;height:40px;width:40px}.logo-container{width:40px;min-width:40px;height:40px;border-radius:22px;align-items:center;justify-content:center;display:flex;background-color:var(--cros-sys-primary_container)}.category-icon{align-items:center;align-self:center;display:flex;height:24px;width:24px}.content{align-items:center;align-self:center;column-gap:16px}</style>
<div id="categoriesList">
  <template is="dom-repeat" rendered-item-count="{{itemRendered}}"
        items="{{categoriesList}}">
    <cr-button id="[[getCategoryId(item.categoryId)]]"
        class="category-item"
        role="checkbox"
        aria-checked="[[item.selected]]"
        on-click="onClick">
      <div class="content flex horizontal layout">
        <div class="logo-container">
          <webview
              id="[[getWebViewId(item.categoryId)]]"
              role="img"
              class="category-icon"
              src="[[getIconUrl(item.icon)]]"
              aria-hidden="true"
              tabindex="-1"
              on-contentload="[[onIconLoaded()]]"
            >
          </webview>
        </div>
        <div class="selected-icon">
          <iron-icon icon="oobe-40:category-selected"></iron-icon>
        </div>
        <div class="text-container">
          <div class="category-title"> [[item.title]]</div>
          <div class="category-subtitle">[[item.subtitle]]</div>
        </div>
      </div>
    </cr-button>
  </template>
</div>
<!--_html_template_end_-->`}