// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cros_color_overrides.css.js";import"//resources/ash/common/cr_elements/cr_slider/cr_slider.js";import"//resources/ash/common/cr_elements/icons.html.js";import{CrSliderElement}from"//resources/ash/common/cr_elements/cr_slider/cr_slider.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{assert}from"chrome://resources/js/assert.js";import{OobeI18nMixin}from"./mixins/oobe_i18n_mixin.js";import{getTemplate}from"./oobe_display_size_selector.html.js";const DEFAULT_APP_ICON_SIZE=48;const DEFAULT_FONT_SIZE=14;const OobeDisplaySizeSelectorBase=OobeI18nMixin(PolymerElement);export class OobeDisplaySizeSelector extends OobeDisplaySizeSelectorBase{static get is(){return"oobe-display-size-selector"}static get template(){return getTemplate()}static get properties(){return{availableSizesTicks:{type:Array},markerCounts:{type:Number},tickedSizeIndex:{type:Number,observer:"updatePreviewSizes"},apps:{type:Array}}}init(availableSizes,currentSize){let currentSizeIndex=0;let minDiff=Math.abs(availableSizes[0]-currentSize);const sliderSizeTicks=[];for(let i=0;i<availableSizes.length;i++){const ariaValue=Math.round(availableSizes[i]*100);const sizeTick={value:availableSizes[i],ariaValue:ariaValue,label:this.i18n("displaySizeValue",ariaValue.toString())};sliderSizeTicks.push(sizeTick);if(minDiff>Math.abs(availableSizes[i]-currentSize)){currentSizeIndex=i;minDiff=Math.abs(availableSizes[i]-currentSize)}}if(document.querySelector("html[dir=rtl]")){this.getSizeSlider().setAttribute("is-rtl_","")}this.availableSizesTicks=sliderSizeTicks;this.tickedSizeIndex=currentSizeIndex;this.markerCounts=this.availableSizesTicks.length;this.apps=[{icon:"images/app_icons/files.svg",name:"displaySizeFilesApp"},{icon:"images/app_icons/photos.svg",name:"displaySizePhotosApp"},{icon:"images/app_icons/calculator.svg",name:"displaySizeCalculatorApp"},{icon:"images/app_icons/camera.svg",name:"displaySizeCameraApp"},{icon:"images/app_icons/settings.svg",name:"displaySizeSettingsApp"},{icon:"images/app_icons/a4.svg",name:"displaySizeA4App"}]}getSelectedSize(){return this.availableSizesTicks[this.tickedSizeIndex].value}updatePreviewSizes(){const selectedSize=this.availableSizesTicks[this.tickedSizeIndex].value;const icons=this.shadowRoot?.querySelectorAll(".app-icon");assert(icons);for(let i=0;i<icons.length;i++){icons[i].style.width=selectedSize*DEFAULT_APP_ICON_SIZE+"px"}const title=this.shadowRoot?.querySelector("#previewTitle");assert(title instanceof HTMLElement);title.style.fontSize=selectedSize*DEFAULT_FONT_SIZE+"px";const names=this.shadowRoot?.querySelectorAll(".app-name");assert(names);for(let i=0;i<names.length;i++){names[i].style.fontSize=selectedSize*DEFAULT_FONT_SIZE+"px"}}getSizeSlider(){const slider=this.shadowRoot?.querySelector("#sizeSlider");assert(slider instanceof CrSliderElement);return slider}onTickedSizeChanged(){this.tickedSizeIndex=this.getSizeSlider().value}onPositiveClicked(){if(this.getSizeSlider().value+1<this.markerCounts){this.getSizeSlider().value+=1;this.tickedSizeIndex+=1}}onNegativeClicked(){if(this.getSizeSlider().value>=1){this.getSizeSlider().value-=1;this.tickedSizeIndex-=1}}}customElements.define(OobeDisplaySizeSelector.is,OobeDisplaySizeSelector);