// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/ash/common/cr_elements/cros_color_overrides.css.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./oobe_personalized_apps_list.html.js";const OobePersonalizedAppsListBase=PolymerElement;export class OobePersonalizedAppsList extends OobePersonalizedAppsListBase{static get is(){return"oobe-personalized-apps-list"}static get template(){return getTemplate()}static get properties(){return{appsList:{type:Array,value:[],notify:true},categoriesMapApps:{type:Object},selectedAppsCount:{type:Number,value:0,notify:true},loadedIconsCount:{type:Number,value:0},categoriesItemRendered:{type:Object,value:[]}}}static get observers(){return["itemRenderedChanged(categoriesItemRendered.*)"]}init(data){this.categoriesMapApps={};for(const categoryAppsItem of data){this.categoriesMapApps[categoryAppsItem.name]=categoryAppsItem.apps}this.selectedAppsCount=0;this.loadedIconsCount=0;this.categoriesItemRendered=[];this.appsList=[];for(const key in this.categoriesMapApps){this.categoriesItemRendered.push({id:key,count:0});this.categoriesMapApps[key].forEach((element=>{this.appsList.push(element)}))}}reset(){this.categoriesMapApps={};this.selectedAppsCount=0;this.loadedIconsCount=0;this.categoriesItemRendered=[];this.appsList=[];this.resetScroll()}resetScroll(){const appsList=this.shadowRoot?.querySelector("#personalizedApps");if(appsList){appsList.scrollTop=0}}itemRenderedChanged(_itemRendered){let count=0;this.categoriesItemRendered.forEach((element=>{count+=element.count}));if(this.appsList.length!==0&&count===this.appsList.length){this.setWebviewStyle();this.dispatchEvent(new CustomEvent("icons-loaded",{bubbles:true,composed:true}))}}setWebviewStyle(){const iconWebviews=this.shadowRoot?.querySelectorAll(".app-icon");if(iconWebviews){for(const iconWebview of iconWebviews){this.injectCss(iconWebview)}}}injectCss(webview){webview.addEventListener("contentload",(()=>{webview.insertCSS({code:`body { background-color: transparent !important; }`},(()=>{if(chrome.runtime.lastError){console.warn("Failed to insertCSS: "+chrome.runtime.lastError.message)}}))}))}shouldShowCategoriesTitle(categoriesMapApps){return!(Object.keys(categoriesMapApps).length>1)}getAppsSelected(){const packageNames=[];this.appsList.forEach((app=>{if(app.selected){packageNames.push(app.package_name)}}));return packageNames}getIconUrl(iconUrl){return iconUrl}getApps(key){return this.categoriesMapApps[key]}updateCount(){let appsSelected=0;this.appsList.forEach((app=>{if(app.selected){appsSelected++}}));this.selectedAppsCount=appsSelected}getAppId(appId){return"cr-checkbox-"+appId}getWebViewId(appId){return"webview-"+appId}onIconLoaded(){this.loadedIconsCount+=1}}customElements.define(OobePersonalizedAppsList.is,OobePersonalizedAppsList);